<?php
/**
 * Accent color
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Start Class
if ( ! class_exists( 'Conceptseven_Accent_Color' ) ) {
	class Conceptseven_Accent_Color {
		// Main constructor
		public function __construct() {
			add_filter( 'conceptseven_custom_colors_css', array( 'Conceptseven_Accent_Color', 'generate' ), 1 );
		}

		// Generates arrays of elements to target
		private static function arrays( $return ) {
			// Color
			$texts = apply_filters( 'conceptseven_accent_texts', array(
				'.text-accent-color', '#site-logo .site-logo-text:hover',
				'.bypostauthor > article .comment-author',
				'.top-bar-style-1 #top-bar .top-bar-socials .icons a:hover',
				'.top-bar-style-2 #top-bar .top-bar-socials .icons a:hover',
				'#main-nav .sub-menu li a:hover',
				'.header-style-1 #site-header .nav-top-cart-wrapper .nav-cart-trigger:hover',
				'.header-style-1 #site-header .header-search-icon:hover',
				'.header-style-1 .search-style-fullscreen .search-submit:hover:after',
				'.header-style-2 #main-nav > ul > li > a:hover',
				'.header-style-2 #site-header .nav-top-cart-wrapper .nav-cart-trigger:hover',
				'.header-style-2 #site-header .header-search-icon:hover',
				'.header-style-2 .search-style-fullscreen .search-submit:hover:after',
				'.header-style-3 .search-style-fullscreen .search-submit:hover:after',
				'.header-style-3 #site-header .nav-top-cart-wrapper .nav-cart-trigger:hover',
				'.header-style-4 .search-style-fullscreen .search-submit:hover:after',
				'.header-style-4 #site-header .nav-top-cart-wrapper .nav-cart-trigger:hover',
				'#featured-title #breadcrumbs a:hover',
				'.sticky-post',
				'.hentry .page-links span',
				'.hentry .page-links a span',
				'.hentry .post-title a:hover',
				'.hentry .post-meta a:hover',
				'.related-news .post-item .meta .cat a:hover',
				'.related-news .post-item h4 a:hover',
				'.related-news .post-item .link a',
				'.related-news .related-post .slick-next:hover:before',
				'.related-news .related-post .slick-prev:hover:before',
				'#comments .comment-respond .form-submit #comment-reply',
				'.widget.widget_categories ul li a:before',
				'.widget.widget_meta ul li a:before',
				'.widget.widget_pages ul li a:before',
				'.widget.widget_archive ul li a:before',
				'.widget.widget_nav_menu ul li a:before',
				'.widget.widget_pages ul li',
				'.widget.widget_nav_menu ul li',
				'.widget.widget_archive ul li',
				'.widget.widget_categories ul li',
				'.widget.widget_meta ul li',
				'.widget.widget_recent_entries ul li',
				'.widget.widget_recent_comments ul li',
				'.widget.widget_rss ul li',
				'.widget.widget_archive ul li a:hover',
				'.widget.widget_categories ul li a:hover',
				'.widget.widget_meta ul li a:hover',
				'.widget.widget_nav_menu ul li a:hover',
				'.widget.widget_pages ul li a:hover',
				'.widget.widget_recent_entries ul li a:hover',
				'.widget.widget_recent_comments ul li a:hover',
				'.widget.widget_rss ul li a:hover',
				'#footer-widgets .widget.widget_archive ul li a:hover',
				'#footer-widgets .widget.widget_categories ul li a:hover',
				'#footer-widgets .widget.widget_meta ul li a:hover',
				'#footer-widgets .widget.widget_nav_menu ul li a:hover',
				'#footer-widgets .widget.widget_pages ul li a:hover',
				'#footer-widgets .widget.widget_recent_entries ul li a:hover',
				'#footer-widgets .widget.widget_recent_comments ul li a:hover',
				'#footer-widgets .widget.widget_rss ul li a:hover',
				'#sidebar .widget.widget_calendar caption',
				'#footer-widgets .widget.widget_calendar caption',
				'.widget.widget_nav_menu .menu > li.current-menu-item > a',
				'.widget.widget_nav_menu .menu > li.current-menu-item',
				'#sidebar .widget.widget_calendar tbody #today',
				'#sidebar .widget.widget_calendar tbody #today a',
				'#sidebar .widget.widget_twitter .timestamp a:hover',
				'#footer-widgets .widget.widget_twitter .timestamp a:hover',
				'#sidebar .widget.widget_socials .socials a:hover',
				'#footer-widgets .widget.widget_socials .socials a:hover',
				'#sidebar .widget.widget_recent_posts h3 a:hover',
				'#footer-widgets .widget.widget_recent_posts h3 a:hover',

				// shortcodes
				'.conceptseven-accordions .accordion-item .accordion-heading:hover',
				'.conceptseven-accordions .accordion-item.has-number .accordion-heading > .inner > .numb',
				'.conceptseven-step-box .numb.accent',
				'.conceptseven-step-box .heading.accent',
				'.conceptseven-step-box .line.accent',
				'.conceptseven-links.accent',
				'.conceptseven-links:hover',
				'.conceptseven-links.style-2.accent',
				'.conceptseven-button.outline.outline-accent',
				'.conceptseven-button.outline.outline-accent .icon',
				'.conceptseven-counter .icon-wrap .icon.accent',
				'.conceptseven-counter .prefix.accent',
				'.conceptseven-counter .suffix.accent',
				'.conceptseven-counter .number.accent',
				'.conceptseven-divider.has-icon .icon-wrap > span.accent',
				'.conceptseven-single-heading .heading.accent',
				'.conceptseven-headings .heading.accent',
				'.conceptseven-icon.accent > .icon',
				'.conceptseven-image-box.style-2 .item .title',
				'.conceptseven-news.style-2 .news-item .text-wrap .title a:hover',
				'.project-related-wrap .project-item a:hover',
				'.project-related-wrap .project-item .link a',
				'.conceptseven-team .socials li a:hover',
				'.conceptseven-team-grid .socials li a:hover',
				'.conceptseven-video-icon.accent a',
				'.conceptseven-list .icon.accent',
				'.owl-theme .owl-nav [class*="owl-"]:hover:after',

				 // Woocommerce
				'.woocommerce-page .woocommerce-MyAccount-content .woocommerce-info .button',
				'.products li .product-info .button',
				'.products li .product-info .added_to_cart',
				'.products li .product-info .add_to_cart_button',
				'.products li .product-info .product_type_variable',
				'.products li .product-info .added_to_cart',
				'.products li h2:hover',
				'.woo-single-post-class .woocommerce-grouped-product-list-item__label a:hover',
				'.woocommerce-page .shop_table.cart .product-name a:hover',
				'.woocommerce-page .shop_table.cart .product-remove a:after',
				'.product_list_widget .product-title:hover',
				'.widget_recent_reviews .product_list_widget a:hover',
				'.widget_product_categories ul li a:hover',
				'.widget.widget_product_search .woocommerce-product-search .search-submit:hover:before',
				'.widget_shopping_cart_content ul li a:hover',

				 // Default Link
				 'a',
			) );

			// Background color
			$backgrounds = apply_filters( 'conceptseven_accent_backgrounds', array(
				'bg-accent',
				'blockquote:before',
				'button, input[type="button"], input[type="reset"], input[type="submit"]',
				'tparrows.custom:hover',
				'#main-nav .sub-menu li a > span:after',
				'#featured-title .main-title > span',
				'.hentry .post-link a',
				'.post-media .slick-prev:hover',
				'.post-media .slick-next:hover',
				'.post-media .slick-dots li.slick-active button',
				'#comments .comment-respond .form-submit #comment-reply:hover',
				'#sidebar .widget.widget_recent_posts .recent-news .thumb.icon',
				'#footer-widgets .widget.widget_recent_posts .recent-news .thumb.icon',
				'#sidebar .widget.widget_tag_cloud .tagcloud a:hover',
				'#footer-widgets .widget.widget_tag_cloud .tagcloud a:hover',
				'.widget_product_tag_cloud .tagcloud a:hover',
				'.footer-promotion',
				'#scroll-top:hover:before',
				'.conceptseven-pagination ul li a.page-numbers:hover',
				'.woocommerce-pagination .page-numbers li .page-numbers:hover',
				'.conceptseven-pagination ul li .page-numbers.current',
				'.woocommerce-pagination .page-numbers li .page-numbers.current',
				'.no-results-content .search-form .search-submit:before',

				// shortcodes
				'.conceptseven-links.style-2 .line.accent',
				'.conceptseven-button.accent',
				'.conceptseven-button.outline.outline-accent:hover',
				'.conceptseven-content-box > .inner.accent',
				'.conceptseven-content-box > .inner.dark-accent',
				'.conceptseven-content-box > .inner.light-accent',
				'.conceptseven-counter .sep.accent',
				'.conceptseven-tabs.style-2 .tab-title .item-title.active',
				'.conceptseven-tabs.style-3 .tab-title .item-title.active',
				'.conceptseven-single-heading .line.accent',
				'.conceptseven-headings .sep.accent',
				'.conceptseven-headings .heading > span',
				'.animated-line > span:before',
				'.animated-line:after',
				'.animated-line > span:after',
				'.animated-line:before',
				'.conceptseven-image-box.style-1 .item .text-wrap',
				'.conceptseven-image-box.style-2 .item .title:before',
				'.conceptseven-images-grid .item-wrap .zoom-popup:hover:after',
				'.conceptseven-images-grid .cbp-nav-next:hover:after',
				'.conceptseven-images-grid .cbp-nav-prev:hover:after',
				'.conceptseven-progress .progress-animate.accent',
				'.conceptseven-subscribe .form-wrap .submit-wrap button',
				'.conceptseven-subscribe.bg-accent',
				'.owl-theme .owl-dots .owl-dot.active span',

				// woocemmerce
				'.woocommerce-page .woo-single-post-class .summary .stock.in-stock',
				'.product .onsale',
				'.woocommerce-page .wc-proceed-to-checkout .button',
				'.woocommerce-page #payment #place_order',
				'.widget_price_filter .price_slider_amount .button:hover',
				'.widget_shopping_cart_content .buttons > a',
			) );

			// Border color
			$borders = apply_filters( 'conceptseven_accent_borders', array(
				'.animsition-loading:after',
				'#comments .comment-respond .form-submit #comment-reply',
				'#sidebar .widget.widget_tag_cloud .tagcloud a:hover',
				'#footer-widgets .widget.widget_tag_cloud .tagcloud a:hover',
				'.widget_product_tag_cloud .tagcloud a:hover',

				// shortcodes
				'.conceptseven-button.outline.outline-accent',
				'.conceptseven-button.outline.outline-accent:hover',
				'.divider-icon-before.accent',
				'.divider-icon-after.accent',
				'.conceptseven-divider.has-icon .divider-double.accent',
				'.conceptseven-testimonials-g3 .avatar-wrap img:hover',
				'.conceptseven-testimonials-g3 .avatar-wrap a.active img',
				'.conceptseven-tabs.style-2 .tab-title .item-title.active > span' => array( 'top' ),
				'.conceptseven-video-icon.white a:after' => array( 'left' ),

				// woocommerce
				'.widget_price_filter .price_slider_amount .button:hover',
				'.widget_price_filter .ui-slider .ui-slider-handle',
			) );

			// Gradient color
			$gradients = apply_filters( 'conceptseven_accent_gradient', array(
				'.conceptseven-progress .progress-animate.accent.gradient'
			) );

			// Return array
			if ( 'texts' == $return ) {
				return $texts;
			} elseif ( 'backgrounds' == $return ) {
				return $backgrounds;
			} elseif ( 'borders' == $return ) {
				return $borders;
			} elseif ( 'gradients' == $return ) {
				return $gradients;
			}
		}

		// Generates the CSS output
		public static function generate( $output ) {

			// Get custom accent
			$default_accent = '#265cdc';
			$custom_accent  = conceptseven_get_mod( 'accent_color' );

			// Return if accent color is empty or equal to default
			if ( ! $custom_accent || ( $default_accent == $custom_accent ) )
				return $output;

			// Define css var
			$css = '';

			// Get arrays
			$texts       = self::arrays( 'texts' );
			$backgrounds = self::arrays( 'backgrounds' );
			$borders     = self::arrays( 'borders' );
			$gradients    = self::arrays( 'gradients' );

			// Texts
			if ( ! empty( $texts ) )
				$css .= implode( ',', $texts ) .'{color:'. $custom_accent .';}';

			// Backgrounds
			if ( ! empty( $backgrounds ) )
				$css .= implode( ',', $backgrounds ) .'{background-color:'. $custom_accent .';}';

			// Borders
			if ( ! empty( $borders ) ) {
				foreach ( $borders as $key => $val ) {
					if ( is_array( $val ) ) {
						$css .= $key .'{';
						foreach ( $val as $key => $val ) {
							$css .= 'border-'. $val .'-color:'. $custom_accent .';';
						}
						$css .= '}'; 
					} else {
						$css .= $val .'{border-color:'. $custom_accent .';}';
					}
				}
			}

			// Gradients
			if ( ! empty( $gradients ) )
				$css .= implode( ',', $gradients ) .'{background: '. conceptseven_hex2rgba($custom_accent, 1) .';background: -moz-linear-gradient(left, '. conceptseven_hex2rgba($custom_accent, 1) .' 0%, '. conceptseven_hex2rgba($custom_accent, 0.3) .' 100%);background: -webkit-linear-gradient( left, '. conceptseven_hex2rgba($custom_accent, 1) .' 0%, '. conceptseven_hex2rgba($custom_accent, 0.3) .' 100% );background: linear-gradient(to right, '. conceptseven_hex2rgba($custom_accent, 1) .' 0%, '. conceptseven_hex2rgba($custom_accent, 0.3) .' 100%) !important;}';

			// Return CSS
			if ( ! empty( $css ) )
				$output .= '/*ACCENT COLOR*/'. $css;

			// Return output css
			return $output;
		}
	}
}

new Conceptseven_Accent_Color();