<?php
get_header();

$related_title = conceptseven_get_mod( 'project_related_title' );
$related_title   = $related_title ? $related_title : esc_html__( 'Related Projects', 'conceptseven' );
$related_query = conceptseven_get_mod( 'project_related_query', '7' );
$related_column = conceptseven_get_mod( 'project_related_column', '3' );
$related_item_gap = conceptseven_get_mod( 'project_related_item_spacing', '30' );
$related_item_crop = conceptseven_get_mod( 'project_related_img_crop', 'post-related' );

$terms = get_the_terms( $post->ID, 'project_category' );
$term_ids = wp_list_pluck( $terms, 'term_id' );
?>
<div class="project-detail-wrap">
	<?php
	while ( have_posts() ) : the_post();
		the_content();
	endwhile; ?>
</div>

<?php if ( conceptseven_get_mod( 'project_related', true )  ): ?>
<div class="project-related-wrap">
		<div class="conceptseven-container">
		<div class="title-wrap"><h2 class="title"><span><?php echo esc_html( $related_title ); ?></span></h2></div>
		<?php
		$query_args = array(
			'post_type' => 'project',
			'tax_query' => array(
				array(
				'taxonomy' => 'project_category',
				'field' => 'term_id',
				'terms' => $term_ids,
				'operator'=> 'IN'
				)),
			'ignore_sticky_posts' => 1,
			'post__not_in'=> array( $post->ID )
		);

		$query_args['posts_per_page'] = $related_query;
		$query = new WP_Query( $query_args );
		if ( $query->have_posts() ) : ?>
			<div class="project-related" data-gap="<?php echo esc_html( $related_item_gap ); ?>" data-column="<?php echo esc_html( $related_column ); ?>">
				<div class="owl-carousel owl-theme">
					<?php while ( $query->have_posts() ) : $query->the_post(); ?>
					<?php wp_enqueue_script( 'conceptseven-owlcarousel' ); ?>

					<div class="project-item">
						<?php
							if ( has_post_thumbnail() ) {
						    	$img_size = 'conceptseven-post-related';
								if ( $related_item_crop == 'rectangle1' ) $img_size = 'conceptseven-rectangle1';
	                    	}

	                    	$text_html = '';

							$terms = wp_get_post_terms( get_the_ID(), 'project_category' );
							if ( $terms )
								$text_html .= '<div class="cat"><a href="'. esc_url( get_term_link( $terms[0]->term_id ) ) .'">'. esc_html( $terms[0]->name ) .'</a></div>';

	                    	$text_html .= '<h2><a href="'. esc_url( get_the_permalink() ) .'">'. esc_attr( get_the_title() ) .'</a></h2>';

	                    	$text_html .= sprintf('<div class="link"><a href="%1$s"><span>%2$s</span></a></div>', esc_url( get_the_permalink() ), esc_html__('VIEW PROJECT', 'conceptseven') );

	                    	echo '<div class="project-wrap"><div class="project-image"><div class="inner">'. get_the_post_thumbnail( get_the_ID(), $img_size ) .'<div class="project-text">' . $text_html .'</div></div></div></div>';
						?>
					</div><!-- /.project-box -->
					<?php endwhile; ?>
				</div><!-- /.owl-carousel -->
			</div><!-- /.project-related -->
		<?php
		endif; wp_reset_postdata();
		?>
	</div><!-- /.conceptseven-container -->
</div><!-- /.project-related-wrap -->
<?php endif; ?>

<?php get_footer(); ?>