<?php
/**
 * Featured Title
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Exit if disabled via Customizer or Metabox
if ( ! conceptseven_get_mod( 'featured_title', true ) || ( is_page() && conceptseven_metabox('hide_featured_title') ) )
    return;

$title = conceptseven_get_mod( 'blog_featured_title', 'Latest News' );
$subtitle = conceptseven_get_mod( 'blog_featured_subtitle', '' );

if ( is_singular() ) {
    $title = get_the_title();
} elseif ( is_search() ) {
    $title = sprintf( esc_html__( 'Search results for &quot;%s&quot;', 'conceptseven' ), get_search_query() );
} elseif ( is_404() ) {
    $title = esc_html__( 'Not Found', 'conceptseven' );
} elseif ( is_author() ) {
    the_post();
    $title = sprintf( esc_html__( 'Author Archives: %s', 'conceptseven' ), get_the_author() );
    rewind_posts();
} elseif ( is_day() ) {
    $title = sprintf( esc_html__( 'Daily Archives: %s', 'conceptseven' ), get_the_date() );
} elseif ( is_month() ) {
    $title = sprintf( esc_html__( 'Monthly Archives: %s', 'conceptseven' ), get_the_date( 'F Y' ) );
} elseif ( is_year() ) {
    $title = sprintf( esc_html__( 'Yearly Archives: %s', 'conceptseven' ), get_the_date( 'Y' ) );
} elseif ( is_tax() || is_category() || is_tag() ) {
    $title = single_term_title( '', false );
}

if ( is_page() && conceptseven_metabox('custom_featured_title' ) ) {
    $title = conceptseven_metabox('custom_featured_title' );
    $subtitle = conceptseven_metabox('custom_featured_subtitle');
}

if ( conceptseven_is_woocommerce_shop() ) {
    $title = conceptseven_get_mod( 'shop_featured_title', 'Our Shop' );
    $subtitle = conceptseven_get_mod( 'shop_featured_subtitle', '' );
}

if ( is_singular( 'product' ) ) {
    $sptitle = conceptseven_get_mod( 'shop_single_featured_title', 'Our Shop' );
    if ( $sptitle != '' ) { $title = $sptitle; }
    else { $title = get_the_title(); }

    $subtitle = conceptseven_get_mod( 'shop_single_featured_subtitle', '' );
}

if ( is_singular( 'post' ) ) {
    $title = conceptseven_get_mod( 'blog_single_featured_title', 'Latest News' );
    $subtitle = conceptseven_get_mod( 'blog_single_featured_subtitle', '' );
}

// Return array to order contents
$featured_title_content = conceptseven_get_mod( 'featured_title_style' )
    ? explode( '_', conceptseven_get_mod( 'featured_title_style' ) )
    : array( "heading", "breadcrumbs" );
?>

<div id="featured-title" class="<?php echo conceptseven_feature_title_cls(); ?>" style="<?php echo conceptseven_featured_title_bg(); ?>">
    <div class="conceptseven-container clearfix">
        <div class="inner-wrap">
            <?php
            foreach ( $featured_title_content as $content ) :
                // Get heading
                if ( 'breadcrumbs' == $content ) {
                    // Dont load if disabled via Customizer
                    if ( conceptseven_get_mod( 'featured_title_breadcrumbs', true ) ) : ?>
                        <div id="breadcrumbs">
                            <div class="breadcrumbs-inner">
                                <div class="breadcrumb-trail">
                                    <?php conceptseven_breadcrumbs(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif;
                }

                if ( 'heading' == $content ) {
                // Get breadcrumbs
                if ( conceptseven_get_mod( 'featured_title_heading', true ) ) : ?>
                    <div class="title-group">
                        <h1 class="main-title">
                            <?php echo esc_html( $title ); ?>
                        </h1>
                        <?php if ( $subtitle ) : ?>
                            <h5 class="sub-title"><?php echo do_shortcode( $subtitle ); ?></h5>
                        <?php endif; ?>
                    </div>
                <?php endif;
                }
            endforeach; ?>
        </div>
    </div>
</div><!-- /#featured-title -->

