<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Change default size for single image shortcode
add_action('init', 'vc_update_defaults', 100);
function vc_update_defaults() {
	if ( class_exists( 'WPBMap' ) )  {
		// Set full size for single image by default
		$param = WPBMap::getParam( 'vc_single_image', 'img_size' );
		$param['value'] = 'full';
		vc_update_shortcode_param( 'vc_single_image', $param );
	}
}

// Add moreparams
add_action('init', 'vc_add_new_para', 100);
	function vc_add_new_para() {
	if ( function_exists( 'add_shortcode_param' ) ) {
		if ( defined( 'WPB_VC_VERSION' ) && version_compare( '5.0', WPB_VC_VERSION, '>=' ) ) {
			add_shortcode_param( 'number' , 'conceptseven_param_number' );
			add_shortcode_param( 'headings' , 'conceptseven_param_heading' );
		}
	}
	if ( function_exists( 'vc_add_shortcode_param' ) ) {
		vc_add_shortcode_param( 'number' , 'conceptseven_param_number' );
		vc_add_shortcode_param( 'headings' , 'conceptseven_param_heading' );
	}

	// Add Number param
	function conceptseven_param_number( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$type = isset($settings['type']) ? $settings['type'] : '';
		$suffix = isset($settings['suffix']) ? $settings['suffix'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$output = '<input type="number" class="wpb_vc_param_value ' . $param_name . ' ' . $type . ' ' . $class . '" name="' . $param_name . '" value="'. $value.'" style="max-width:100px; margin-right: 10px;" />'. $suffix;
		return $output;
	}

	// Add Heading param
	function conceptseven_param_heading( $settings, $value ) {
		$dependency = '';
		$param_name = isset($settings['param_name']) ? $settings['param_name'] : '';
		$class = isset($settings['class']) ? $settings['class'] : '';
		$text = isset($settings['text']) ? $settings['text'] : '';
		$output = '<h4 '. $dependency .' class="wpb_vc_param_value '. $class .'" style="margin: 10px 0 0;padding:10px;font-size:14px; background:#ebebeb;color:#666;">'. $text .'</h4>';
		$output .= '<input type="hidden" name="'. $settings['param_name'].'" class="wpb_vc_param_value '. $settings['param_name'] .' '. $settings['type'] .'_field" value="'. $value.'" '. $dependency.'/>';
		return $output;
	}
}

// Register Backend and Frontend CSS Styles
add_action( 'vc_base_register_front_css', 'leadinjection_vc_iconpicker_base_register_css' );
add_action( 'vc_base_register_admin_css', 'leadinjection_vc_iconpicker_base_register_css' );
function leadinjection_vc_iconpicker_base_register_css(){
    wp_enqueue_style('extraicon', plugin_dir_url( __FILE__ ) . '/assets/eleganticons.css');
}

// Define the Icons for VC Iconpicker
add_filter( 'vc_iconpicker-type-extraicon', 'vc_iconpicker_type_extraicon' );
function vc_iconpicker_type_extraicon() {
    return array(
array("elegant-arrow_up" => "elegant-arrow_up"),
array("elegant-arrow_down" => "elegant-arrow_down"),
array("elegant-arrow_left" => "elegant-arrow_left"),
array("elegant-arrow_right" => "elegant-arrow_right"),
array("elegant-arrow_left-up" => "elegant-arrow_left-up"),
array("elegant-arrow_right-up" => "elegant-arrow_right-up"),
array("elegant-arrow_right-down" => "elegant-arrow_right-down"),
array("elegant-arrow_left-down" => "elegant-arrow_left-down"),
array("elegant-arrow-up-down" => "elegant-arrow-up-down"),
array("elegant-arrow_up-down_alt" => "elegant-arrow_up-down_alt"),
array("elegant-arrow_left-right_alt" => "elegant-arrow_left-right_alt"),
array("elegant-arrow_left-right" => "elegant-arrow_left-right"),
array("elegant-arrow_expand_alt2" => "elegant-arrow_expand_alt2"),
array("elegant-arrow_expand_alt" => "elegant-arrow_expand_alt"),
array("elegant-arrow_condense" => "elegant-arrow_condense"),
array("elegant-arrow_expand" => "elegant-arrow_expand"),
array("elegant-arrow_move" => "elegant-arrow_move"),
array("elegant-arrow_carrot-up" => "elegant-arrow_carrot-up"),
array("elegant-arrow_carrot-down" => "elegant-arrow_carrot-down"),
array("elegant-arrow_carrot-left" => "elegant-arrow_carrot-left"),
array("elegant-arrow_carrot-right" => "elegant-arrow_carrot-right"),
array("elegant-arrow_carrot-2up" => "elegant-arrow_carrot-2up"),
array("elegant-arrow_carrot-2down" => "elegant-arrow_carrot-2down"),
array("elegant-arrow_carrot-2left" => "elegant-arrow_carrot-2left"),
array("elegant-arrow_carrot-2right" => "elegant-arrow_carrot-2right"),
array("elegant-arrow_carrot-up_alt2" => "elegant-arrow_carrot-up_alt2"),
array("elegant-arrow_carrot-down_alt2" => "elegant-arrow_carrot-down_alt2"),
array("elegant-arrow_carrot-left_alt2" => "elegant-arrow_carrot-left_alt2"),
array("elegant-arrow_carrot-right_alt2" => "elegant-arrow_carrot-right_alt2"),
array("elegant-arrow_carrot-2up_alt2" => "elegant-arrow_carrot-2up_alt2"),
array("elegant-arrow_carrot-2down_alt2" => "elegant-arrow_carrot-2down_alt2"),
array("elegant-arrow_carrot-2left_alt2" => "elegant-arrow_carrot-2left_alt2"),
array("elegant-arrow_carrot-2right_alt2" => "elegant-arrow_carrot-2right_alt2"),
array("elegant-arrow_triangle-up" => "elegant-arrow_triangle-up"),
array("elegant-arrow_triangle-down" => "elegant-arrow_triangle-down"),
array("elegant-arrow_triangle-left" => "elegant-arrow_triangle-left"),
array("elegant-arrow_triangle-right" => "elegant-arrow_triangle-right"),
array("elegant-arrow_triangle-up_alt2" => "elegant-arrow_triangle-up_alt2"),
array("elegant-arrow_triangle-down_alt2" => "elegant-arrow_triangle-down_alt2"),
array("elegant-arrow_triangle-left_alt2" => "elegant-arrow_triangle-left_alt2"),
array("elegant-arrow_triangle-right_alt2" => "elegant-arrow_triangle-right_alt2"),
array("elegant-arrow_back" => "elegant-arrow_back"),
array("elegant-icon_minus-06" => "elegant-icon_minus-06"),
array("elegant-icon_plus" => "elegant-icon_plus"),
array("elegant-icon_close" => "elegant-icon_close"),
array("elegant-icon_check" => "elegant-icon_check"),
array("elegant-icon_minus_alt2" => "elegant-icon_minus_alt2"),
array("elegant-icon_plus_alt2" => "elegant-icon_plus_alt2"),
array("elegant-icon_close_alt2" => "elegant-icon_close_alt2"),
array("elegant-icon_check_alt2" => "elegant-icon_check_alt2"),
array("elegant-icon_zoom-out_alt" => "elegant-icon_zoom-out_alt"),
array("elegant-icon_zoom-in_alt" => "elegant-icon_zoom-in_alt"),
array("elegant-icon_search" => "elegant-icon_search"),
array("elegant-icon_box-empty" => "elegant-icon_box-empty"),
array("elegant-icon_box-selected" => "elegant-icon_box-selected"),
array("elegant-icon_minus-box" => "elegant-icon_minus-box"),
array("elegant-icon_plus-box" => "elegant-icon_plus-box"),
array("elegant-icon_box-checked" => "elegant-icon_box-checked"),
array("elegant-icon_circle-empty" => "elegant-icon_circle-empty"),
array("elegant-icon_circle-slelected" => "elegant-icon_circle-slelected"),
array("elegant-icon_stop_alt2" => "elegant-icon_stop_alt2"),
array("elegant-icon_stop" => "elegant-icon_stop"),
array("elegant-icon_pause_alt2" => "elegant-icon_pause_alt2"),
array("elegant-icon_pause" => "elegant-icon_pause"),
array("elegant-icon_menu" => "elegant-icon_menu"),
array("elegant-icon_menu-square_alt2" => "elegant-icon_menu-square_alt2"),
array("elegant-icon_menu-circle_alt2" => "elegant-icon_menu-circle_alt2"),
array("elegant-icon_ul" => "elegant-icon_ul"),
array("elegant-icon_ol" => "elegant-icon_ol"),
array("elegant-icon_adjust-horiz" => "elegant-icon_adjust-horiz"),
array("elegant-icon_adjust-vert" => "elegant-icon_adjust-vert"),
array("elegant-icon_document_alt" => "elegant-icon_document_alt"),
array("elegant-icon_documents_alt" => "elegant-icon_documents_alt"),
array("elegant-icon_pencil" => "elegant-icon_pencil"),
array("elegant-icon_pencil-edit_alt" => "elegant-icon_pencil-edit_alt"),
array("elegant-icon_pencil-edit" => "elegant-icon_pencil-edit"),
array("elegant-icon_folder-alt" => "elegant-icon_folder-alt"),
array("elegant-icon_folder-open_alt" => "elegant-icon_folder-open_alt"),
array("elegant-icon_folder-add_alt" => "elegant-icon_folder-add_alt"),
array("elegant-icon_info_alt" => "elegant-icon_info_alt"),
array("elegant-icon_error-oct_alt" => "elegant-icon_error-oct_alt"),
array("elegant-icon_error-circle_alt" => "elegant-icon_error-circle_alt"),
array("elegant-icon_error-triangle_alt" => "elegant-icon_error-triangle_alt"),
array("elegant-icon_question_alt2" => "elegant-icon_question_alt2"),
array("elegant-icon_question" => "elegant-icon_question"),
array("elegant-icon_comment_alt" => "elegant-icon_comment_alt"),
array("elegant-icon_chat_alt" => "elegant-icon_chat_alt"),
array("elegant-icon_vol-mute_alt" => "elegant-icon_vol-mute_alt"),
array("elegant-icon_volume-low_alt" => "elegant-icon_volume-low_alt"),
array("elegant-icon_volume-high_alt" => "elegant-icon_volume-high_alt"),
array("elegant-icon_quotations" => "elegant-icon_quotations"),
array("elegant-icon_quotations_alt2" => "elegant-icon_quotations_alt2"),
array("elegant-icon_clock_alt" => "elegant-icon_clock_alt"),
array("elegant-icon_lock_alt" => "elegant-icon_lock_alt"),
array("elegant-icon_lock-open_alt" => "elegant-icon_lock-open_alt"),
array("elegant-icon_key_alt" => "elegant-icon_key_alt"),
array("elegant-icon_cloud_alt" => "elegant-icon_cloud_alt"),
array("elegant-icon_cloud-upload_alt" => "elegant-icon_cloud-upload_alt"),
array("elegant-icon_cloud-download_alt" => "elegant-icon_cloud-download_alt"),
array("elegant-icon_image" => "elegant-icon_image"),
array("elegant-icon_images" => "elegant-icon_images"),
array("elegant-icon_lightbulb_alt" => "elegant-icon_lightbulb_alt"),
array("elegant-icon_gift_alt" => "elegant-icon_gift_alt"),
array("elegant-icon_house_alt" => "elegant-icon_house_alt"),
array("elegant-icon_genius" => "elegant-icon_genius"),
array("elegant-icon_mobile" => "elegant-icon_mobile"),
array("elegant-icon_tablet" => "elegant-icon_tablet"),
array("elegant-icon_laptop" => "elegant-icon_laptop"),
array("elegant-icon_desktop" => "elegant-icon_desktop"),
array("elegant-icon_camera_alt" => "elegant-icon_camera_alt"),
array("elegant-icon_mail_alt" => "elegant-icon_mail_alt"),
array("elegant-icon_cone_alt" => "elegant-icon_cone_alt"),
array("elegant-icon_ribbon_alt" => "elegant-icon_ribbon_alt"),
array("elegant-icon_bag_alt" => "elegant-icon_bag_alt"),
array("elegant-icon_creditcard" => "elegant-icon_creditcard"),
array("elegant-icon_cart_alt" => "elegant-icon_cart_alt"),
array("elegant-icon_paperclip" => "elegant-icon_paperclip"),
array("elegant-icon_tag_alt" => "elegant-icon_tag_alt"),
array("elegant-icon_tags_alt" => "elegant-icon_tags_alt"),
array("elegant-icon_trash_alt" => "elegant-icon_trash_alt"),
array("elegant-icon_cursor_alt" => "elegant-icon_cursor_alt"),
array("elegant-icon_mic_alt" => "elegant-icon_mic_alt"),
array("elegant-icon_compass_alt" => "elegant-icon_compass_alt"),
array("elegant-icon_pin_alt" => "elegant-icon_pin_alt"),
array("elegant-icon_pushpin_alt" => "elegant-icon_pushpin_alt"),
array("elegant-icon_map_alt" => "elegant-icon_map_alt"),
array("elegant-icon_drawer_alt" => "elegant-icon_drawer_alt"),
array("elegant-icon_toolbox_alt" => "elegant-icon_toolbox_alt"),
array("elegant-icon_book_alt" => "elegant-icon_book_alt"),
array("elegant-icon_calendar" => "elegant-icon_calendar"),
array("elegant-icon_film" => "elegant-icon_film"),
array("elegant-icon_table" => "elegant-icon_table"),
array("elegant-icon_contacts_alt" => "elegant-icon_contacts_alt"),
array("elegant-icon_headphones" => "elegant-icon_headphones"),
array("elegant-icon_lifesaver" => "elegant-icon_lifesaver"),
array("elegant-icon_piechart" => "elegant-icon_piechart"),
array("elegant-icon_refresh" => "elegant-icon_refresh"),
array("elegant-icon_link_alt" => "elegant-icon_link_alt"),
array("elegant-icon_link" => "elegant-icon_link"),
array("elegant-icon_loading" => "elegant-icon_loading"),
array("elegant-icon_blocked" => "elegant-icon_blocked"),
array("elegant-icon_archive_alt" => "elegant-icon_archive_alt"),
array("elegant-icon_heart_alt" => "elegant-icon_heart_alt"),
array("elegant-icon_star_alt" => "elegant-icon_star_alt"),
array("elegant-icon_star-half_alt" => "elegant-icon_star-half_alt"),
array("elegant-icon_star" => "elegant-icon_star"),
array("elegant-icon_star-half" => "elegant-icon_star-half"),
array("elegant-icon_tools" => "elegant-icon_tools"),
array("elegant-icon_tool" => "elegant-icon_tool"),
array("elegant-icon_cog" => "elegant-icon_cog"),
array("elegant-icon_cogs" => "elegant-icon_cogs"),
array("elegant-arrow_up_alt" => "elegant-arrow_up_alt"),
array("elegant-arrow_down_alt" => "elegant-arrow_down_alt"),
array("elegant-arrow_left_alt" => "elegant-arrow_left_alt"),
array("elegant-arrow_right_alt" => "elegant-arrow_right_alt"),
array("elegant-arrow_left-up_alt" => "elegant-arrow_left-up_alt"),
array("elegant-arrow_right-up_alt" => "elegant-arrow_right-up_alt"),
array("elegant-arrow_right-down_alt" => "elegant-arrow_right-down_alt"),
array("elegant-arrow_left-down_alt" => "elegant-arrow_left-down_alt"),
array("elegant-arrow_condense_alt" => "elegant-arrow_condense_alt"),
array("elegant-arrow_expand_alt3" => "elegant-arrow_expand_alt3"),
array("elegant-arrow_carrot_up_alt" => "elegant-arrow_carrot_up_alt"),
array("elegant-arrow_carrot-down_alt" => "elegant-arrow_carrot-down_alt"),
array("elegant-arrow_carrot-left_alt" => "elegant-arrow_carrot-left_alt"),
array("elegant-arrow_carrot-right_alt" => "elegant-arrow_carrot-right_alt"),
array("elegant-arrow_carrot-2up_alt" => "elegant-arrow_carrot-2up_alt"),
array("elegant-arrow_carrot-2dwnn_alt" => "elegant-arrow_carrot-2dwnn_alt"),
array("elegant-arrow_carrot-2left_alt" => "elegant-arrow_carrot-2left_alt"),
array("elegant-arrow_carrot-2right_alt" => "elegant-arrow_carrot-2right_alt"),
array("elegant-arrow_triangle-up_alt" => "elegant-arrow_triangle-up_alt"),
array("elegant-arrow_triangle-down_alt" => "elegant-arrow_triangle-down_alt"),
array("elegant-arrow_triangle-left_alt" => "elegant-arrow_triangle-left_alt"),
array("elegant-arrow_triangle-right_alt" => "elegant-arrow_triangle-right_alt"),
array("elegant-icon_minus_alt" => "elegant-icon_minus_alt"),
array("elegant-icon_plus_alt" => "elegant-icon_plus_alt"),
array("elegant-icon_close_alt" => "elegant-icon_close_alt"),
array("elegant-icon_check_alt" => "elegant-icon_check_alt"),
array("elegant-icon_zoom-out" => "elegant-icon_zoom-out"),
array("elegant-icon_zoom-in" => "elegant-icon_zoom-in"),
array("elegant-icon_stop_alt" => "elegant-icon_stop_alt"),
array("elegant-icon_menu-square_alt" => "elegant-icon_menu-square_alt"),
array("elegant-icon_menu-circle_alt" => "elegant-icon_menu-circle_alt"),
array("elegant-icon_document" => "elegant-icon_document"),
array("elegant-icon_documents" => "elegant-icon_documents"),
array("elegant-icon_pencil_alt" => "elegant-icon_pencil_alt"),
array("elegant-icon_folder" => "elegant-icon_folder"),
array("elegant-icon_folder-open" => "elegant-icon_folder-open"),
array("elegant-icon_folder-add" => "elegant-icon_folder-add"),
array("elegant-icon_folder_upload" => "elegant-icon_folder_upload"),
array("elegant-icon_folder_download" => "elegant-icon_folder_download"),
array("elegant-icon_info" => "elegant-icon_info"),
array("elegant-icon_error-circle" => "elegant-icon_error-circle"),
array("elegant-icon_error-oct" => "elegant-icon_error-oct"),
array("elegant-icon_error-triangle" => "elegant-icon_error-triangle"),
array("elegant-icon_question_alt" => "elegant-icon_question_alt"),
array("elegant-icon_comment" => "elegant-icon_comment"),
array("elegant-icon_chat" => "elegant-icon_chat"),
array("elegant-icon_vol-mute" => "elegant-icon_vol-mute"),
array("elegant-icon_volume-low" => "elegant-icon_volume-low"),
array("elegant-icon_volume-high" => "elegant-icon_volume-high"),
array("elegant-icon_quotations_alt" => "elegant-icon_quotations_alt"),
array("elegant-icon_clock" => "elegant-icon_clock"),
array("elegant-icon_lock" => "elegant-icon_lock"),
array("elegant-icon_lock-open" => "elegant-icon_lock-open"),
array("elegant-icon_key" => "elegant-icon_key"),
array("elegant-icon_cloud" => "elegant-icon_cloud"),
array("elegant-icon_cloud-upload" => "elegant-icon_cloud-upload"),
array("elegant-icon_cloud-download" => "elegant-icon_cloud-download"),
array("elegant-icon_lightbulb" => "elegant-icon_lightbulb"),
array("elegant-icon_gift" => "elegant-icon_gift"),
array("elegant-icon_house" => "elegant-icon_house"),
array("elegant-icon_camera" => "elegant-icon_camera"),
array("elegant-icon_mail" => "elegant-icon_mail"),
array("elegant-icon_cone" => "elegant-icon_cone"),
array("elegant-icon_ribbon" => "elegant-icon_ribbon"),
array("elegant-icon_bag" => "elegant-icon_bag"),
array("elegant-icon_cart" => "elegant-icon_cart"),
array("elegant-icon_tag" => "elegant-icon_tag"),
array("elegant-icon_tags" => "elegant-icon_tags"),
array("elegant-icon_trash" => "elegant-icon_trash"),
array("elegant-icon_cursor" => "elegant-icon_cursor"),
array("elegant-icon_mic" => "elegant-icon_mic"),
array("elegant-icon_compass" => "elegant-icon_compass"),
array("elegant-icon_pin" => "elegant-icon_pin"),
array("elegant-icon_pushpin" => "elegant-icon_pushpin"),
array("elegant-icon_map" => "elegant-icon_map"),
array("elegant-icon_drawer" => "elegant-icon_drawer"),
array("elegant-icon_toolbox" => "elegant-icon_toolbox"),
array("elegant-icon_book" => "elegant-icon_book"),
array("elegant-icon_contacts" => "elegant-icon_contacts"),
array("elegant-icon_archive" => "elegant-icon_archive"),
array("elegant-icon_heart" => "elegant-icon_heart"),
array("elegant-icon_profile" => "elegant-icon_profile"),
array("elegant-icon_group" => "elegant-icon_group"),
array("elegant-icon_grid-2x2" => "elegant-icon_grid-2x2"),
array("elegant-icon_grid-3x3" => "elegant-icon_grid-3x3"),
array("elegant-icon_music" => "elegant-icon_music"),
array("elegant-icon_pause_alt" => "elegant-icon_pause_alt"),
array("elegant-icon_phone" => "elegant-icon_phone"),
array("elegant-icon_upload" => "elegant-icon_upload"),
array("elegant-icon_download" => "elegant-icon_download"),
array("elegant-social_facebook" => "elegant-social_facebook"),
array("elegant-social_twitter" => "elegant-social_twitter"),
array("elegant-social_pinterest" => "elegant-social_pinterest"),
array("elegant-social_googleplus" => "elegant-social_googleplus"),
array("elegant-social_tumblr" => "elegant-social_tumblr"),
array("elegant-social_tumbleupon" => "elegant-social_tumbleupon"),
array("elegant-social_wordpress" => "elegant-social_wordpress"),
array("elegant-social_instagram" => "elegant-social_instagram"),
array("elegant-social_dribbble" => "elegant-social_dribbble"),
array("elegant-social_vimeo" => "elegant-social_vimeo"),
array("elegant-social_linkedin" => "elegant-social_linkedin"),
array("elegant-social_rss" => "elegant-social_rss"),
array("elegant-social_deviantart" => "elegant-social_deviantart"),
array("elegant-social_share" => "elegant-social_share"),
array("elegant-social_myspace" => "elegant-social_myspace"),
array("elegant-social_skype" => "elegant-social_skype"),
array("elegant-social_youtube" => "elegant-social_youtube"),
array("elegant-social_picassa" => "elegant-social_picassa"),
array("elegant-social_googledrive" => "elegant-social_googledrive"),
array("elegant-social_flickr" => "elegant-social_flickr"),
array("elegant-social_blogger" => "elegant-social_blogger"),
array("elegant-social_spotify" => "elegant-social_spotify"),
array("elegant-social_delicious" => "elegant-social_delicious"),
array("elegant-social_facebook_circle" => "elegant-social_facebook_circle"),
array("elegant-social_twitter_circle" => "elegant-social_twitter_circle"),
array("elegant-social_pinterest_circle" => "elegant-social_pinterest_circle"),
array("elegant-social_googleplus_circle" => "elegant-social_googleplus_circle"),
array("elegant-social_tumblr_circle" => "elegant-social_tumblr_circle"),
array("elegant-social_stumbleupon_circle" => "elegant-social_stumbleupon_circle"),
array("elegant-social_wordpress_circle" => "elegant-social_wordpress_circle"),
array("elegant-social_instagram_circle" => "elegant-social_instagram_circle"),
array("elegant-social_dribbble_circle" => "elegant-social_dribbble_circle"),
array("elegant-social_vimeo_circle" => "elegant-social_vimeo_circle"),
array("elegant-social_linkedin_circle" => "elegant-social_linkedin_circle"),
array("elegant-social_rss_circle" => "elegant-social_rss_circle"),
array("elegant-social_deviantart_circle" => "elegant-social_deviantart_circle"),
array("elegant-social_share_circle" => "elegant-social_share_circle"),
array("elegant-social_myspace_circle" => "elegant-social_myspace_circle"),
array("elegant-social_skype_circle" => "elegant-social_skype_circle"),
array("elegant-social_youtube_circle" => "elegant-social_youtube_circle"),
array("elegant-social_picassa_circle" => "elegant-social_picassa_circle"),
array("elegant-social_googledrive_alt2" => "elegant-social_googledrive_alt2"),
array("elegant-social_flickr_circle" => "elegant-social_flickr_circle"),
array("elegant-social_blogger_circle" => "elegant-social_blogger_circle"),
array("elegant-social_spotify_circle" => "elegant-social_spotify_circle"),
array("elegant-social_delicious_circle" => "elegant-social_delicious_circle"),
array("elegant-social_facebook_square" => "elegant-social_facebook_square"),
array("elegant-social_twitter_square" => "elegant-social_twitter_square"),
array("elegant-social_pinterest_square" => "elegant-social_pinterest_square"),
array("elegant-social_googleplus_square" => "elegant-social_googleplus_square"),
array("elegant-social_tumblr_square" => "elegant-social_tumblr_square"),
array("elegant-social_stumbleupon_square" => "elegant-social_stumbleupon_square"),
array("elegant-social_wordpress_square" => "elegant-social_wordpress_square"),
array("elegant-social_instagram_square" => "elegant-social_instagram_square"),
array("elegant-social_dribbble_square" => "elegant-social_dribbble_square"),
array("elegant-social_vimeo_square" => "elegant-social_vimeo_square"),
array("elegant-social_linkedin_square" => "elegant-social_linkedin_square"),
array("elegant-social_rss_square" => "elegant-social_rss_square"),
array("elegant-social_deviantart_square" => "elegant-social_deviantart_square"),
array("elegant-social_share_square" => "elegant-social_share_square"),
array("elegant-social_myspace_square" => "elegant-social_myspace_square"),
array("elegant-social_skype_square" => "elegant-social_skype_square"),
array("elegant-social_youtube_square" => "elegant-social_youtube_square"),
array("elegant-social_picassa_square" => "elegant-social_picassa_square"),
array("elegant-social_googledrive_square" => "elegant-social_googledrive_square"),
array("elegant-social_flickr_square" => "elegant-social_flickr_square"),
array("elegant-social_blogger_square" => "elegant-social_blogger_square"),
array("elegant-social_spotify_square" => "elegant-social_spotify_square"),
array("elegant-social_delicious_square" => "elegant-social_delicious_square"),
array("elegant-icon_printer" => "elegant-icon_printer"),
array("elegant-icon_calulator" => "elegant-icon_calulator"),
array("elegant-icon_building" => "elegant-icon_building"),
array("elegant-icon_floppy" => "elegant-icon_floppy"),
array("elegant-icon_drive" => "elegant-icon_drive"),
array("elegant-icon_search-2" => "elegant-icon_search-2"),
array("elegant-icon_id" => "elegant-icon_id"),
array("elegant-icon_id-2" => "elegant-icon_id-2"),
array("elegant-icon_puzzle" => "elegant-icon_puzzle"),
array("elegant-icon_like" => "elegant-icon_like"),
array("elegant-icon_dislike" => "elegant-icon_dislike"),
array("elegant-icon_mug" => "elegant-icon_mug"),
array("elegant-icon_currency" => "elegant-icon_currency"),
array("elegant-icon_wallet" => "elegant-icon_wallet"),
array("elegant-icon_pens" => "elegant-icon_pens"),
array("elegant-icon_easel" => "elegant-icon_easel"),
array("elegant-icon_flowchart" => "elegant-icon_flowchart"),
array("elegant-icon_datareport" => "elegant-icon_datareport"),
array("elegant-icon_briefcase" => "elegant-icon_briefcase"),
array("elegant-icon_shield" => "elegant-icon_shield"),
array("elegant-icon_percent" => "elegant-icon_percent"),
array("elegant-icon_globe" => "elegant-icon_globe"),
array("elegant-icon_globe-2" => "elegant-icon_globe-2"),
array("elegant-icon_target" => "elegant-icon_target"),
array("elegant-icon_hourglass" => "elegant-icon_hourglass"),
array("elegant-icon_balance" => "elegant-icon_balance"),
array("elegant-icon_rook" => "elegant-icon_rook"),
array("elegant-icon_printer-alt" => "elegant-icon_printer-alt"),
array("elegant-icon_calculator_alt" => "elegant-icon_calculator_alt"),
array("elegant-icon_building_alt" => "elegant-icon_building_alt"),
array("elegant-icon_floppy_alt" => "elegant-icon_floppy_alt"),
array("elegant-icon_drive_alt" => "elegant-icon_drive_alt"),
array("elegant-icon_search_alt" => "elegant-icon_search_alt"),
array("elegant-icon_id_alt" => "elegant-icon_id_alt"),
array("elegant-icon_id-2_alt" => "elegant-icon_id-2_alt"),
array("elegant-icon_puzzle_alt" => "elegant-icon_puzzle_alt"),
array("elegant-icon_like_alt" => "elegant-icon_like_alt"),
array("elegant-icon_dislike_alt" => "elegant-icon_dislike_alt"),
array("elegant-icon_mug_alt" => "elegant-icon_mug_alt"),
array("elegant-icon_currency_alt" => "elegant-icon_currency_alt"),
array("elegant-icon_wallet_alt" => "elegant-icon_wallet_alt"),
array("elegant-icon_pens_alt" => "elegant-icon_pens_alt"),
array("elegant-icon_easel_alt" => "elegant-icon_easel_alt"),
array("elegant-icon_flowchart_alt" => "elegant-icon_flowchart_alt"),
array("elegant-icon_datareport_alt" => "elegant-icon_datareport_alt"),
array("elegant-icon_briefcase_alt" => "elegant-icon_briefcase_alt"),
array("elegant-icon_shield_alt" => "elegant-icon_shield_alt"),
array("elegant-icon_percent_alt" => "elegant-icon_percent_alt"),
array("elegant-icon_globe_alt" => "elegant-icon_globe_alt"),
array("elegant-icon_clipboard" => "elegant-icon_clipboard")
    );
}

// Return simple fonts array
if ( ! function_exists('conceptseven_plugin_google_font') ) {
	function conceptseven_plugin_google_font() {
		if ( function_exists('conceptseven_google_fonts_array') ) {
			$default = array( 0 => 'Default' );
			return array_merge( $default, conceptseven_google_fonts_array() );
		} else {
			return array(
				'Default', 'Arial, Helvetica, sans-serif', 'Arial Black, Gadget, sans-serif',
				'Bookman Old Style, serif', 'Comic Sans MS, cursive', 'Courier, monospace',
				'Georgia, serif', 'Garamond, serif', 'Impact, Charcoal, sans-serif', 'Lucida Console, Monaco, monospace',
				'Lucida Sans Unicode, Lucida Grande, sans-serif', 'MS Sans Serif, Geneva, sans-serif', 'MS Serif, New York, sans-serif',
				'Palatino Linotype, Book Antiqua, Palatino, serif', 'Tahoma, Geneva, sans-serif', 'Times New Roman, Times, serif',
				'Trebuchet MS, Helvetica, sans-serif', 'Verdana, Geneva, sans-serif', 'Paratina Linotype', 'Trebuchet MS',
			);
		}
	}
}

// Get icon font base on font icon type
if ( ! function_exists('conceptseven_get_icon_class') ) {
	function conceptseven_get_icon_class( $atts, $icon_location ) {
		// Define vars
		$icon = '';
		$icon_type = ! empty( $atts['icon_type'] ) ? $atts['icon_type'] : 'fontawesome';

		// Generate fontawesome icon class
		if ( 'fontawesome' == $icon_type && ! empty( $atts[$icon_location] ) ) {
			$icon = $atts[$icon_location];
			$icon = str_replace( 'fa-', '', $icon );
			$icon = str_replace( 'fa ', '', $icon );
			$icon = 'fa fa-'. $icon;
		} elseif ( ! empty( $atts[ $icon_location .'_'. $icon_type ] ) ) {
			$icon = $atts[ $icon_location .'_'. $icon_type ];
		}

		// Sanitize
		$icon = in_array( $icon, array( 'icon', 'none' ) ) ? '' : $icon;

		// Return icon class
		return $icon;
	}
}

// Spacing
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Spacing', 'conceptseven'),
        'description' => esc_html__('Empty space with custom height.', 'conceptseven'),
        'base' => 'spacing',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
	        array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Desktop: Height', 'conceptseven'),
				'param_name' => 'desktop_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Mobile: Height', 'conceptseven'),
				'param_name' => 'mobile_height',
				'value' => '',
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Small Mobile: Height', 'conceptseven'),
				'param_name' => 'smobile_height',
				'value' => '',
	        ),
        )
    ) );
} );

// Carousel Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_carouselbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Carousel Box', 'conceptseven'),
		'description' => esc_html__('Scrolling anything.', 'conceptseven'),
		'base' => 'carouselbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('only' => 'contentbox, imagebox, iconbox, videoicon, simpleimage, testimonials, headings, fancytext, singleheading, pricetables, counter'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'conceptseven' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'conceptseven' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'conceptseven'),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Spacing Between', 'conceptseven'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'conceptseven' ),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'conceptseven'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'conceptseven' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'conceptseven' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'conceptseven'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'conceptseven' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'conceptseven' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Top' => 'top',
					'Center' => 'center',
					'Bottom' => 'bottom',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'conceptseven' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => array('top', 'bottom') ),
			),
			// Column
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'conceptseven' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'conceptseven' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Portfolio Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Portfolio Carousel', 'conceptseven'),
        'description' => esc_html__('Displaying project posts in carousel.', 'conceptseven'),
        'base' => 'portfolio',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'conceptseven' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Default' => 'default',
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'640 x 440' => 'rectangle1',
					'640 x 880' => 'rectangle2',
					'370 x 270' => 'rectangle3',
					'370 x 740' => 'rectangle4',
				),
				'std'		=> 'rectangle1',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'conceptseven'),
				'param_name' => 'gap',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'conceptseven'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'conceptseven'),
				'param_name' => 'items',
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'conceptseven'),
				'param_name' => 'cat_slug',
				'value' => '',
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Exclude Category Slug (Optional)', 'conceptseven'),
				'param_name' => 'exclude_cat_slug',
				'value' => '',
				'description'	=> esc_html__('Exclude posts that have this category. Using category-slug.', 'conceptseven'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'conceptseven' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'conceptseven'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'conceptseven' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'conceptseven' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'conceptseven' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'conceptseven'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'conceptseven' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'conceptseven' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'conceptseven' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'conceptseven' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Portfolio Grid
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Portfolio Grid', 'conceptseven'),
        'description' => esc_html__('Displaying project posts in grid with filter bar.', 'conceptseven'),
        'base' => 'portfoliogrid',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'conceptseven' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Masonry' => 'masonry',
					'Mosaic' => 'mosaic',
				),
				'std'		=> 'masonry',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'conceptseven' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Default' => 'default',
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'640 x 440' => 'rectangle1',
					'640 x 880' => 'rectangle2',
					'370 x 270' => 'rectangle3',
					'370 x 740' => 'rectangle4',
				),
				'std'		=> 'rectangle1',
				'description'	=> esc_html__('Choose <Default> to use Image-Cropping from metabox.', 'conceptseven'),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'conceptseven'),
				'param_name' => 'gapv',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'conceptseven'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'conceptseven'),
				'param_name' => 'gaph',
				'value' => '0',
				'description'	=> esc_html__('Ex: 30', 'conceptseven'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Rounded Image?', 'conceptseven' ),
				'param_name' => 'rounded',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
            // Query
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Posts Per Page', 'conceptseven'),
				'param_name' => 'items',
				'group'      => esc_html__( 'Query', 'conceptseven' ),
				'value' => '8',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'conceptseven'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Exclude Category Slug (Optional)', 'conceptseven'),
				'param_name' => 'exclude_cat_slug',
				'value' => '',
				'description'	=> esc_html__('Exclude posts that have this category. Using category-slug.', 'conceptseven'),
	        ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Pagination?', 'conceptseven' ),
				'param_name' => 'pagination',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'false',
			),
			// Filter
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Filter Bar?', 'conceptseven' ),
				'param_name' => 'show_filter',
				'group' => esc_html__( 'Filter', 'conceptseven' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: All', 'conceptseven'),
				'param_name' => 'filter_button_all',
				'value' => 'All',
				'group' => esc_html__( 'Filter', 'conceptseven' ),
				'description'	=> esc_html__('Leave it empty to disable.', 'conceptseven'),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'conceptseven'),
				'param_name' => 'bottom_filter',
				'value' => '',
				'description'	=> esc_html__('Ex: 45px.', 'conceptseven'),
				'group' => esc_html__( 'Filter', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter Alignment', 'conceptseven' ),
				'param_name' => 'filter_align',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Filter', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Show Counter?', 'conceptseven' ),
				'param_name' => 'show_counter',
				'group' => esc_html__( 'Filter', 'conceptseven' ),
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Filter posts by default?', 'conceptseven' ),
				'param_name' => 'filter_by_default',
				'group' => esc_html__( 'Filter', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
				'dependency' => array( 'element' => 'show_filter', 'value' => 'true' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'conceptseven'),
				'param_name' => 'filter_cat_slug',
				'value' => '',
				'group' => esc_html__( 'Filter', 'conceptseven' ),
				'dependency' => array( 'element' => 'filter_by_default', 'value' => 'yes' ),
				'description'	=> esc_html__('Filter posts from this category by default. Using category-slug.', 'conceptseven'),
	        ),
            // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Font Family', 'conceptseven' ),
				'param_name' => 'filter_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Font Weight', 'conceptseven' ),
				'param_name' => 'filter_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Font Size', 'conceptseven'),
				'param_name' => 'filter_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Line-Height', 'conceptseven'),
				'param_name' => 'filter_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Filter: Letter Spacing', 'conceptseven'),
				'param_name' => 'filter_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Filter: Text Transform', 'conceptseven' ),
				'param_name' => 'filter_text_tranform',
				'value'      => array(
					'Capitalize' => 'capitalize',
					'Uppercase' => 'uppercase',
				),
				'std'		=> 'capitalize',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c'
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px', 'conceptseven' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px', 'conceptseven' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px', 'conceptseven' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Testimonials
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Testimonials', 'conceptseven'),
	    'description' => esc_html__('Displaying testimonials box.', 'conceptseven'),
	    'base' => 'testimonials',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'conceptseven'),
				'param_name' => 'image',
				'value' => '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'conceptseven'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Default: 80px.', 'conceptseven'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Style', 'conceptseven' ),
				'param_name' => 'image_style',
				'value'      => array(
					'Square' => 'image-square',
					'Circle' => 'image-circle',
				),
				'std'		=> 'image-circle',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap: Background', 'conceptseven'),
				'param_name' => 'wrap_background',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Padding', 'conceptseven'),
				'param_name' => 'wrap_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'conceptseven'),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Rounded', 'conceptseven'),
				'param_name' => 'wrap_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'conceptseven'),
            ),
	        // Text
			array(
				'type' 		=> 'textarea',
				'heading' 	=> esc_html__('Text', 'conceptseven'),
				'param_name' 	=> 'text',
				'value' 		=> '',
				'group' => esc_html__( 'Text', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'conceptseven'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Text', 'conceptseven' ),
            ),
            // Name
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Name', 'conceptseven'),
				'param_name' => 'name',
				'value' => 'JOHN ROE',
				'group' => esc_html__( 'Name & Position', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'conceptseven'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Name & Position', 'conceptseven' ),
            ),
            // Position
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Position', 'conceptseven'),
				'param_name' => 'position',
				'value' => 'Sale Manager',
				'group' => esc_html__( 'Name & Position', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'conceptseven'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Name & Position', 'conceptseven' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'conceptseven'),
				'param_name' => 'text_typography',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Family', 'conceptseven' ),
				'param_name' => 'text_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Weight', 'conceptseven' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Font Size', 'conceptseven'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Font Style', 'conceptseven' ),
				'param_name' => 'text_font_style',
				'value'      => array(
					'Normal' => 'normal',
					'Italic' => 'italic',
				),
				'std'		=> 'normal',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text Line-height', 'conceptseven'),
				'param_name' => 'text_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'conceptseven'),
				'param_name' => 'name_typography',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'conceptseven' ),
				'param_name' => 'name_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'conceptseven' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'conceptseven'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-height', 'conceptseven'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'conceptseven'),
				'param_name' => 'position_typography',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'conceptseven' ),
				'param_name' => 'position_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'conceptseven' ),
				'param_name' => 'company_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'conceptseven'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-height', 'conceptseven'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image: Bottom Margin', 'conceptseven'),
				'param_name' => 'image_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-1')  ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image: Right Margin', 'conceptseven'),
				'param_name' => 'image_right_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => array('style-2', 'style-3')  ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'conceptseven'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        // Effect
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hover Style', 'conceptseven' ),
				'param_name' => 'hover_style',
				'value'      => array(
					'No' => '',
					'Yes' => 'hover_effect',
				),
				'std'		=> '',
				'group' => esc_html__( 'Effect Hover', 'conceptseven' ),
			),
	    )
	) );
} );


// Testimonials Group 3
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Testimonials - Group 3', 'conceptseven'),
	    'description' => esc_html__('Displaying testimonials posts.', 'conceptseven'),
	    'base' => 'testimonials3',
		'weight'	=>	180,
		'show_settings_on_create' => false,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	) );
} );

// News Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('News Carousel', 'conceptseven'),
	    'description' => esc_html__('Displaying blog posts in carousel.', 'conceptseven'),
	    'base' => 'news',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Thumbnail Image', 'conceptseven' ),
				'param_name' => 'thumb',
				'value'      => array(
					'Featured Image' => 'featured-image',
					'Element Thumbnail' => 'element-thumbnail',
				),
				'std'		=> 'featured-image',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Thumbnail Cropping', 'conceptseven' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'770 x 500' => 'standard',
					'570 x 277' => 'related',
				),
				'std'		=> 'standard',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding.', 'conceptseven'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 20px 17px 30px 17px', 'conceptseven'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Background', 'conceptseven'),
				'param_name' => 'content_background',
				'value' => '#f7f7f7',
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Hide Meta Post?', 'conceptseven' ),
				'param_name' => 'hide_meta',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'conceptseven'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'conceptseven'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Displaying posts that have this category. Using category-slug.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'conceptseven'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'conceptseven'),
	        ),
			// Link
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Text', 'conceptseven'),
				'param_name' => 'link_text',
				'value' => 'Read more',
				'group' => esc_html__( 'Link', 'conceptseven' ),
	        ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'conceptseven' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'conceptseven'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'conceptseven' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'conceptseven' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'conceptseven'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'conceptseven' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'conceptseven' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Center' => 'center',
					'Top' => 'top',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'conceptseven' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'top' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'conceptseven' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'conceptseven' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'conceptseven'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'conceptseven'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'conceptseven'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'conceptseven'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'conceptseven'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	    )
	) );
} );

// ProgressBar
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Progress Bar', 'conceptseven'),
        'description' => esc_html__('Displaying progress bars.', 'conceptseven'),
        'base' => 'progressbar',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'conceptseven'),
				'param_name' => 'title',
				'value' => esc_html__('Title', 'conceptseven'),
				'description' => esc_html__('Title of the ProgressBar.', 'conceptseven')
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'conceptseven'),
				'param_name' => 'title_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Percentage', 'conceptseven'),
				'param_name' => 'percent',
				'value' => '90',
				'description' => esc_html__('Percentage value of the ProgressBar', 'conceptseven')
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Percentage Color', 'conceptseven'),
				'param_name' => 'per_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height of Bars', 'conceptseven'),
				'param_name' => 'height',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Space between Text & Line', 'conceptseven'),
				'param_name' => 'space_between',
				'value' => '10px',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'conceptseven'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 5px', 'conceptseven'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'conceptseven'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'description'	=> esc_html__('Ex: 20px', 'conceptseven'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 1', 'conceptseven'),
				'param_name' => 'line_one',
				'value' => '#636363',
				'group' => esc_html__( 'Line Color', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line 2', 'conceptseven'),
				'param_name' => 'line_two',
				'value' => '#e5e5e5',
				'group' => esc_html__( 'Line Color', 'conceptseven' ),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable gradient color?', 'conceptseven' ),
				'param_name' => 'gradient',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
				'group' => esc_html__( 'Line Color', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'conceptseven' ),
				'param_name' => 'font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'conceptseven' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'conceptseven'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
        )
    ) );
} );

// Accordions
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_accordions extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Accordions or Toggles', 'conceptseven' ),
        'description' => esc_html__('Displaying Accordions or Toggles', 'conceptseven'),
		'base'        => 'accordions',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'accordion' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Type', 'conceptseven' ),
				'param_name' => 'type',
				'value'      => array(
					'Accordions' => 'accordions',
					'Toggles' => 'toggles',
				),
				'std'		=> 'accordions',
			),
		)
	) );
} );

// Accordion
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Item', 'conceptseven' ),
    'description' => esc_html__('Item for Accordions or Toggles', 'conceptseven'),
		'base'        => 'accordion',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'as_child'    => array( 'only' => 'accordions' ),
		'params'      => array(
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Active by default?', 'conceptseven' ),
				'param_name' => 'open',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Active Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'conceptseven'),
				'param_name' => 'bg_image',
				'value' => '',
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Bottom Margin', 'conceptseven'),
				'param_name' => 'bottom_margin',
				'value' => 10,
				'suffix' => 'px',
				'description'	=> esc_html__('Default: 10px', 'conceptseven'),
		  	),
			// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'conceptseven' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Heading', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading Number', 'conceptseven'),
				'param_name' => 'heading_number',
				'value' => '',
				'group' => esc_html__( 'Heading', 'conceptseven' ),
            ),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Heading', 'conceptseven' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Background', 'conceptseven' ),
				'param_name' => 'heading_bg',
				'value'      => array(
					'Transparent' => 'transparent',
					'White' => 'white',
					'Grey' => 'grey',
				),
				'std'		=> 'transparent',
				'group' => esc_html__( 'Heading', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Padding', 'conceptseven'),
				'param_name' => 'heading_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 25px 13px 25px', 'conceptseven'),
				'group' => esc_html__( 'Heading', 'conceptseven' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'conceptseven'),
				'param_name' => 'heading_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 25px', 'conceptseven'),
				'group' => esc_html__( 'Heading', 'conceptseven' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'conceptseven'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'conceptseven'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 20px 0px 30px 0px', 'conceptseven'),
				'group' => esc_html__( 'Content', 'conceptseven' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'conceptseven'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
		)
	) );
} );

// Tabs
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_dtabs extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Tabs', 'conceptseven' ),
        'description' => esc_html__('Displaying Tabbed Content.', 'conceptseven'),
		'base'        => 'dtabs',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array( 'only' => 'dtab' ),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title: Width', 'conceptseven' ),
				'param_name' => 'title_width',
				'value'      => array(
					'150px' => 'w150',
					'160px' => 'w160',
					'170px' => 'w170',
					'180px' => 'w180',
					'190px' => 'w190',
					'200px' => 'w200',
					'220px' => 'w220',
					'240px' => 'w240',
					'260px' => 'w260',
					'280px' => 'w280',
					'300px' => 'w300',
				),
				'std'		=> 'w190',
				'dependency' => array( 'element' => 'style', 'value' => array('style-3','style-4')),
	        ),
		)
	) );
} );

// Tab
add_action( 'vc_before_init', function() {
	vc_map( array(
	'name'        => esc_html__( 'Tab', 'conceptseven' ),
    'description' => esc_html__('Displaying Tab.', 'conceptseven'),
		'base'        => 'dtab',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'as_child'    => array( 'only' => 'dtabs' ),
		'params'      => array(
			// Title
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Title', 'conceptseven'),
				'param_name' => 'title',
				'value' => 'Tab',
				'group' => esc_html__( 'Title', 'conceptseven' ),
            ),
	        // Content
			array(
				'type' 		=> 'textarea_html',
				'heading' 	=> esc_html__('Content', 'conceptseven'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'conceptseven'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 20px 0px 0px 37px;', 'conceptseven'),
				'group' => esc_html__( 'Content', 'conceptseven' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Family', 'conceptseven' ),
				'param_name' => 'title_font_family',
				'value'      => conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Title Font Weight', 'conceptseven' ),
				'param_name' => 'title_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Font Size', 'conceptseven'),
				'param_name' => 'title_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Line-Height', 'conceptseven'),
				'param_name' => 'title_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
		)
	) );
} );

// Team Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Team Carousel', 'conceptseven'),
	    'description' => esc_html__('Displaying member posts in carousel.', 'conceptseven'),
	    'base' => 'team',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'conceptseven' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
				),
				'std'		=> 'full',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'conceptseven'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 8px 20px 35px 20px', 'conceptseven'),
	        ),
            // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'conceptseven'),
				'param_name' => 'items',
				'value' => '4',
				'group' => esc_html__( 'Query', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'conceptseven'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Display posts that have this category. Using category-slug.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'conceptseven'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'conceptseven' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'conceptseven' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'conceptseven' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'conceptseven'),
			),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'conceptseven'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'conceptseven' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Elements', 'conceptseven' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'conceptseven'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'conceptseven' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Position', 'conceptseven' ),
				'param_name' => 'arrow_position',
				'value'      => array(
					'Center' => 'center',
					'Top' => 'top',
				),
				'std'		=> 'center',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'conceptseven' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'center' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset_s',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
					'45' => '45',
					'50' => '50',
					'55' => '55',
					'60' => '60',
					'65' => '65',
					'70' => '70',
					'75' => '75',
					'80' => '80',
					'85' => '85',
					'90' => '90',
					'95' => '95',
					'100' => '100',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'arrow_position', 'value' => 'top' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'conceptseven' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'conceptseven' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'conceptseven'),
				'param_name' => 'name_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'conceptseven' ),
				'param_name' => 'name_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'conceptseven' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'conceptseven'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'conceptseven'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-Height', 'conceptseven'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'conceptseven'),
				'param_name' => 'position_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'conceptseven' ),
				'param_name' => 'position_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'conceptseven' ),
				'param_name' => 'position_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'conceptseven'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'conceptseven'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-Height', 'conceptseven'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			// Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'conceptseven'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Bottom Margin', 'conceptseven'),
				'param_name' => 'name_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Top Margin', 'conceptseven'),
				'param_name' => 'position_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Bottom Margin', 'conceptseven'),
				'param_name' => 'position_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	    )
	) );
} );

// Team Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Team Grid', 'conceptseven'),
	    'description' => esc_html__('Displaying member posts in grid.', 'conceptseven'),
	    'base' => 'teamgrid',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'conceptseven' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
					'600 x 390' => 'rectangle2',
				),
				'std'		=> 'full',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'conceptseven'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 8px 20px 35px 20px', 'conceptseven'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'conceptseven'),
				'param_name' => 'content_background',
				'value' => '',
            ),
            // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'conceptseven'),
				'param_name' => 'items',
				'value' => '3',
				'group' => esc_html__( 'Query', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug (Optional)', 'conceptseven'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Display posts that have this category. Using category-slug.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'conceptseven'),
				'param_name' => 'gapv',
				'value' => '30',
				'group' => esc_html__( 'Query', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'conceptseven'),
				'param_name' => 'gaph',
				'value' => '40',
				'group' => esc_html__( 'Query', 'conceptseven' ),
	        ),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Column(s)', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '3c',
			),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Name', 'conceptseven'),
				'param_name' => 'name_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Family', 'conceptseven' ),
				'param_name' => 'name_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Name Font Weight', 'conceptseven' ),
				'param_name' => 'name_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Name Color', 'conceptseven'),
				'param_name' => 'name_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Font Size', 'conceptseven'),
				'param_name' => 'name_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name Line-Height', 'conceptseven'),
				'param_name' => 'name_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Position', 'conceptseven'),
				'param_name' => 'position_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Family', 'conceptseven' ),
				'param_name' => 'position_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Position Font Weight', 'conceptseven' ),
				'param_name' => 'position_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Position Color', 'conceptseven'),
				'param_name' => 'position_color',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Font Size', 'conceptseven'),
				'param_name' => 'position_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position Line-Height', 'conceptseven'),
				'param_name' => 'position_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			// Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Top Margin', 'conceptseven'),
				'param_name' => 'name_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Name: Bottom Margin', 'conceptseven'),
				'param_name' => 'name_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Top Margin', 'conceptseven'),
				'param_name' => 'position_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Position: Bottom Margin', 'conceptseven'),
				'param_name' => 'position_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	    )
	) );
} );

// Action Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Action Box', 'conceptseven'),
	    'description' => esc_html__('Displaying Action-Box or Promo-Box.', 'conceptseven'),
	    'base' => 'actionbox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	    'params' => array(
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Area: Width', 'conceptseven'),
				'param_name' => 'content_width',
				'value' => '',
				'description'	=> esc_html__('Default: 70%', 'conceptseven'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Area: Alignment', 'conceptseven' ),
				'param_name' => 'content_align',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Area: Width', 'conceptseven'),
				'param_name' => 'button_width',
				'value' => '',
				'description'	=> esc_html__('Default: 20%', 'conceptseven'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Area: Alignment', 'conceptseven' ),
				'param_name' => 'button_align',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-right',
			),
            // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading_content',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'conceptseven' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading Text', 'conceptseven'),
				'param_name' => 'heading_text',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'conceptseven'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Max-Width', 'conceptseven'),
				'param_name' => 'heading_width',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
            // Button
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text (Required)', 'conceptseven'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'Button', 'conceptseven' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button URL (Required):', 'conceptseven'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
            ),
            array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__('Button Extra Text', 'conceptseven'),
				'param_name' => 'link_ex_text',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Extra Text Color', 'conceptseven'),
				'param_name' => 'link_ex_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'conceptseven' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Button', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'conceptseven' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Background' => 'background',
					'Outline' => 'outline',
				),
				'std'		=> 'background',
				'group' => esc_html__( 'Button', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'conceptseven' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'Button', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'conceptseven'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'conceptseven'),
				'group' => esc_html__( 'Button', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'conceptseven'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'conceptseven'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border', 'conceptseven'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'outline' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'conceptseven'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'conceptseven'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'conceptseven'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'Button', 'conceptseven' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'outline' ),
            ),
            // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'conceptseven'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'conceptseven'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'conceptseven' ),
				'param_name' => 'button_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'conceptseven' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'conceptseven'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'conceptseven'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'conceptseven'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Top Margin', 'conceptseven'),
				'param_name' => 'button_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button: Bottom Margin', 'conceptseven'),
				'param_name' => 'button_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	    )
	) );
} );

// Image Box
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Image Box', 'conceptseven'),
	    'description' => esc_html__('Displaying image box.', 'conceptseven'),
	    'base' => 'imagebox',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	    'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> '',
			),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'conceptseven'),
				'param_name' => 'image',
				'value' => '',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Padding', 'conceptseven'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Mobile Padding', 'conceptseven'),
				'param_name' => 'content_mobi_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'conceptseven'),
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'hading_content',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'conceptseven' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading',
				'value' => 'Heading Text',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Separator', 'conceptseven'),
				'param_name' => 'separator_content',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'conceptseven' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line'
				),
				'std'		=> '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line: Full-width', 'conceptseven' ),
				'param_name' => 'line_full',
				'value'      => array(
					'No' => 'no',
					'Yes' => 'yes',
				),
				'std'		=> 'no',
				'group' => esc_html__( 'Content', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'conceptseven'),
				'param_name' => 'line_width',
				'value' => '50',
				'group' => esc_html__( 'Content', 'conceptseven' ),
				'dependency' => array( 'element' => 'line_full', 'value' => 'no' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'conceptseven'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Content', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'conceptseven'),
				'param_name' => 'line_color',
				'value' => '#eee',
				'group' => esc_html__( 'Content', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'conceptseven'),
				'param_name' => 'desc_content',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
			array(
				'type' 		=> 'textarea',
				'heading' 	=> esc_html__('Description', 'conceptseven'),
				'param_name' 	=> 'description',
				'value' 		=> '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
			// Button or Link
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Link or Button?', 'conceptseven' ),
				'param_name' => 'show_url',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
				'group' => esc_html__( 'URL', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'url_style',
				'value'      => array(
					'Link' => 'link',
					'Button' => 'button',
				),
				'std'		=> 'link',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text (Required)', 'conceptseven'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('URL (Required):', 'conceptseven'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'conceptseven' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'conceptseven' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Background' => 'background',
					'Outline' => 'outline',
				),
				'std'		=> 'background',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'conceptseven' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'conceptseven'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'conceptseven'),
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'conceptseven'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'conceptseven'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'background' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border', 'conceptseven'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'outline' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'conceptseven'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'conceptseven'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'conceptseven'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'outline' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'conceptseven'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'conceptseven'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'conceptseven' ),
				'param_name' => 'desc_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'conceptseven' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'conceptseven'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'conceptseven'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'conceptseven'),
				'param_name' => 'btn_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'conceptseven' ),
				'param_name' => 'button_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'conceptseven' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'conceptseven'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'conceptseven'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Separator: Top Margin', 'conceptseven'),
				'param_name' => 'sep_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Separator: Bottom Margin', 'conceptseven'),
				'param_name' => 'sep_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'conceptseven'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'conceptseven'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	    )
	) );
} );

// Links
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Links', 'conceptseven' ),
        'description' => esc_html__('Displaying a link.', 'conceptseven'),
		'base'        => 'advlinks',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
				),
				'std'		=> 'style-1',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Content (Required)', 'conceptseven' ),
				'param_name' => 'content',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'conceptseven'),
				'param_name' => 'color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (Required)', 'conceptseven'),
				'param_name' => 'link_url',
				'value' => '',
            ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'conceptseven' ),
				'param_name' => 'content_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'conceptseven' ),
				'param_name' => 'content_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'conceptseven'),
				'param_name' => 'content_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
		)
	) );
} );

// List
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'List', 'conceptseven' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'conceptseven'),
		'base'        => 'advlist',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'conceptseven'),
				'param_name' => 'content_background_color',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'conceptseven' ),
				'param_name' => 'content_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'conceptseven'),
				'param_name' => 'content_border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'conceptseven'),
				'param_name' => 'content_border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'conceptseven'),
				'param_name' => 'content_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 12px 30px 12px 30px', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'conceptseven'),
				'param_name' => 'content_bottom_margin',
				'value' => '',
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'conceptseven' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'conceptseven' ),
				'value' => array(
					esc_html__( '', 'conceptseven' ) => '',
					esc_html__( 'Elegant Icons', 'conceptseven' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'conceptseven' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'conceptseven' ) => 'openiconic',
					esc_html__( 'Typicons', 'conceptseven' ) => 'typicons',
					esc_html__( 'Entypo', 'conceptseven' ) => 'entypo',
					esc_html__( 'Linecons', 'conceptseven' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'conceptseven' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Style', 'conceptseven' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'Simple' => 'simple',
					'Background' => 'background',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background', 'conceptseven'),
				'param_name' => 'icon_bg',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'conceptseven'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Width', 'conceptseven'),
				'param_name' => 'icon_width',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Height', 'conceptseven'),
				'param_name' => 'icon_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line-Height', 'conceptseven'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Rounded', 'conceptseven'),
				'param_name' => 'icon_rounded',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array(
					'element' => 'icon_style',
					'value' => 'background',
				),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'conceptseven'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'conceptseven' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Middle' => 'icon-middle',
					'Top' => 'icon-top',
				),
				'std'		=> 'icon-middle',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Icon Top Margin', 'conceptseven' ),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			// Content
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Content', 'conceptseven' ),
				'param_name' => 'content',
				'group' => esc_html__( 'Content', 'conceptseven' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Content Color', 'conceptseven'),
				'param_name' => 'content_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Left Padding', 'conceptseven'),
				'param_name' => 'content_left_padding',
				'value' => '30',
				'group' => esc_html__( 'Content', 'conceptseven' ),
				'description'	=> esc_html__('Spacing between the icon and the content', 'conceptseven'),
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Family', 'conceptseven' ),
				'param_name' => 'content_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Font Weight', 'conceptseven' ),
				'param_name' => 'content_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Font Size', 'conceptseven'),
				'param_name' => 'content_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content Line-Height', 'conceptseven'),
				'param_name' => 'content_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
		)
	) );
} );

// Menu List
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Menu List', 'conceptseven'),
	    'description' => esc_html__('Menu List.', 'conceptseven'),
	    'base' => 'menulist',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'conceptseven'),
				'param_name' => 'background',
				'value' => '#f5f5f5',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'conceptseven'),
				'param_name' => 'border_color',
				'value' => '#b2b2b2',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'conceptseven'),
				'param_name' => 'border_width',
				'value' => '1px 0px 1px 0px',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'conceptseven' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
				),
				'std'		=> 'solid',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'conceptseven'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 10px 20px 10px 20px', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Bottom Margin', 'conceptseven'),
				'param_name' => 'bottom_margin',
				'value' => '10',
	        ),
	        // Content
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'conceptseven'),
				'param_name' => 'text_content',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'conceptseven'),
				'param_name' => 'text',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'conceptseven'),
				'param_name' => 'text_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'conceptseven'),
				'param_name' => 'value_content',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Value', 'conceptseven'),
				'param_name' => 'value',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'conceptseven'),
				'param_name' => 'value_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text', 'conceptseven'),
				'param_name' => 'text_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Family', 'conceptseven' ),
				'param_name' => 'text_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text: Font Weight', 'conceptseven' ),
				'param_name' => 'text_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text: Font Size', 'conceptseven'),
				'param_name' => 'text_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Value', 'conceptseven'),
				'param_name' => 'value_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Family', 'conceptseven' ),
				'param_name' => 'value_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Value: Font Weight', 'conceptseven' ),
				'param_name' => 'value_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Value: Font Size', 'conceptseven'),
				'param_name' => 'value_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
		)
	) );
} );

// Icon Box
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icon Box', 'conceptseven' ),
        'description' => esc_html__('Displaying Icon Box with custom icon.', 'conceptseven'),
		'base'        => 'iconbox',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Icon Top' => 'icon-top',
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
					'Icon Left 2' => 'icon-left2',
				),
				'std'		=> 'icon-top',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'conceptseven' ),
				'param_name' => 'text_align',
				'value'      => array(
					'Left' => 'align-left',
					'Center' => 'align-center',
					'Right' => 'align-right',
				),
				'std'		=> 'align-left',
				'dependency' => array( 'element' => 'style', 'value' => 'icon-top' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'conceptseven' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'Icon Font' => 'icon-font',
					'Icon Image' => 'icon-image',
				),
				'std'		=> 'icon-font',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Padding', 'conceptseven'),
				'param_name' => 'wrap_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'conceptseven'),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Background', 'conceptseven'),
				'param_name' => 'wrap_background',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Rounded', 'conceptseven'),
				'param_name' => 'wrap_rounded',
				'value' => '',
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Wrap Border Color', 'conceptseven'),
				'param_name' => 'wrap_border',
				'value' => '#e7e7e7',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap Border Width', 'conceptseven'),
				'param_name' => 'wrap_border_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 1px', 'conceptseven'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Wrap Border Style', 'conceptseven' ),
				'param_name' => 'wrap_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
			),
			// Box Shadow
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'conceptseven' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Shadow', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'conceptseven'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Shadow', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'conceptseven'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Shadow', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'conceptseven'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Shadow', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'conceptseven'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Shadow', 'conceptseven' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'conceptseven'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Shadow', 'conceptseven' ),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'conceptseven'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Image', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width', 'conceptseven'),
				'param_name' => 'image_width',
				'value' => '',
				'description'	=> esc_html__('Ex: 100px', 'conceptseven'),
				'group' => esc_html__( 'Image', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-image' ),
	        ),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'conceptseven' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'conceptseven' ),
				'value' => array(
					esc_html__( '', 'conceptseven' ) => '',
					esc_html__( 'Elegant Icons', 'conceptseven' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'conceptseven' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'conceptseven' ) => 'openiconic',
					esc_html__( 'Typicons', 'conceptseven' ) => 'typicons',
					esc_html__( 'Entypo', 'conceptseven' ) => 'entypo',
					esc_html__( 'Linecons', 'conceptseven' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'conceptseven' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'conceptseven'),
				'param_name' => 'icon_font_size',
				'value' => '30px',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Style', 'conceptseven' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'Background' => 'background',
					'Outline' => 'outline',
				),
				'std'		=> 'background',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Width', 'conceptseven'),
				'param_name' => 'icon_width',
				'value' => '60',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Height', 'conceptseven'),
				'param_name' => 'icon_height',
				'value' => '60',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line Height', 'conceptseven'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Rounded', 'conceptseven'),
				'param_name' => 'icon_rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'conceptseven'),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'conceptseven'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background', 'conceptseven'),
				'param_name' => 'icon_background',
				'value' => '',
				'dependency' => array( 'element' => 'icon_style', 'value' => 'background' ),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Border Color', 'conceptseven'),
				'param_name' => 'icon_border',
				'value' => '',
				'dependency' => array( 'element' => 'icon_style', 'value' => 'outline' ),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Border Width', 'conceptseven'),
				'param_name' => 'icon_border_width',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'conceptseven'),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'outline' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Border Style', 'conceptseven' ),
				'param_name' => 'icon_border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'outline' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color: Hover', 'conceptseven'),
				'param_name' => 'icon_color_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Background: Hover', 'conceptseven'),
				'param_name' => 'icon_background_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Border: Hover', 'conceptseven'),
				'param_name' => 'icon_border_hover',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'outline' ),
            ),
			// Content
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'conceptseven' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Content', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'conceptseven'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
			array(
				'type' => 'textarea',
				'heading' => esc_html__( 'Description', 'conceptseven' ),
				'param_name' => 'description',
				'group' => esc_html__( 'Content', 'conceptseven' ), 
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'conceptseven'),
				'param_name' => 'desc_color',
				'value' => '',
				'group' => esc_html__( 'Content', 'conceptseven' ),
            ),
			// Button or Link
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Link or Button?', 'conceptseven' ),
				'param_name' => 'show_url',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
				'group' => esc_html__( 'URL', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'url_style',
				'value'      => array(
					'Link' => 'link',
					'Button' => 'button',
				),
				'std'		=> 'link',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text (Required)', 'conceptseven'),
				'param_name' => 'link_text',
				'value' => 'READ MORE',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
	        ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('URL (Required):', 'conceptseven'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'conceptseven' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_url', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'conceptseven' ),
				'param_name' => 'button_style',
				'value'      => array(
					'Background' => 'background',
					'Outline' => 'outline',
				),
				'std'		=> 'background',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Size', 'conceptseven' ),
				'param_name' => 'button_size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Rounded', 'conceptseven'),
				'param_name' => 'button_rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 30px', 'conceptseven'),
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text Color', 'conceptseven'),
				'param_name' => 'button_text_color',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background', 'conceptseven'),
				'param_name' => 'button_background',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'background' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border', 'conceptseven'),
				'param_name' => 'button_border',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'outline' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Text: Hover', 'conceptseven'),
				'param_name' => 'button_text_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Background: Hover', 'conceptseven'),
				'param_name' => 'button_background_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'url_style', 'value' => 'button' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Button Border: Hover', 'conceptseven'),
				'param_name' => 'button_border_hover',
				'value' => '',
				'group' => esc_html__( 'URL', 'conceptseven' ),
				'dependency' => array( 'element' => 'button_style', 'value' => 'outline' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Line-Height', 'conceptseven'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'conceptseven'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Family', 'conceptseven' ),
				'param_name' => 'desc_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description Font Weight', 'conceptseven' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Font Size', 'conceptseven'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description Line-Height', 'conceptseven'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Button', 'conceptseven'),
				'param_name' => 'button_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Family', 'conceptseven' ),
				'param_name' => 'button_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Font Weight', 'conceptseven' ),
				'param_name' => 'button_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Font Size', 'conceptseven'),
				'param_name' => 'button_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Line-Height', 'conceptseven'),
				'param_name' => 'button_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Top Margin', 'conceptseven'),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Left Padding', 'conceptseven'),
				'param_name' => 'content_left_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'conceptseven' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Right Padding', 'conceptseven'),
				'param_name' => 'content_right_padding',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'conceptseven' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-right' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Left Margin', 'conceptseven'),
				'param_name' => 'heading_left_margin',
				'value' => '85px',
				'group' => esc_html__( 'Spacing', 'conceptseven' ), 
				'dependency' => array( 'element' => 'style', 'value' => 'icon-left2' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'conceptseven'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'conceptseven'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'conceptseven'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        // Hover
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hover Style', 'conceptseven' ),
				'param_name' => 'hover_style',
				'value'      => array(
					'No' => '',
					'Yes' => 'hover-style-1',
				),
				'std'		=> '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
			),
		)
	) );
} );

// PriceTable
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Price Tables', 'conceptseven' ),
        'description' => esc_html__('Displaying Price Tables with 2,3,4 columns.', 'conceptseven'),
		'base'        => 'pricetables',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Style', 'conceptseven' ),
				'param_name'  => 'style',
				'value'       => array(
					'Group 2' 	   => 'two',
					'Group 3'        => 'three',
					'Group 4'        => 'four',
				),
				'std'		=> 'two',
				'group' => esc_html__( 'Price Tables', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Gutter?', 'conceptseven' ),
				'param_name' => 'gutter',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
				'group' => esc_html__( 'Price Tables', 'conceptseven' ),
			),
            // params group
            array(
				'type' => 'param_group',
				'heading' => 'Price Table Box',
				'value' => '',
				'param_name' => 'pricebox',
				'group' => esc_html__( 'Price Tables', 'conceptseven' ),
				'params' => array(
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Top Margin', 'conceptseven'),
						'param_name' => 'top_margin',
						'value' => '',
			        ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Background', 'conceptseven'),
						'param_name' => 'background',
						'value' => '',
		            ),
		            array(
						'type' => 'textfield',
						'heading' => esc_html__('Rounded', 'conceptseven'),
						'param_name' => 'rounded',
						'value' => '',
						'description'	=> esc_html__('Ex: 5px', 'conceptseven'),
		            ),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Box Shadow', 'conceptseven' ),
						'param_name' => 'shadow',
						'value'      => array(
							'No' => 'no_shadow',
							'Yes' => 'box_shadow',
						),
						'std'		=> 'no_shadow',
					),
		            array(
						'type' => 'textfield',
						'heading' => esc_html__('Heading', 'conceptseven'),
						'param_name' => 'heading',
						'value' => '',
		            ),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Heading Color', 'conceptseven' ),
						'param_name' => 'heading_color',
						'value'      => array(
							'Default' => 'default',
							'Accent' => 'accent',
						),
						'std'		=> 'default',
					),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Price Padding', 'conceptseven'),
						'param_name' => 'price_padding',
						'value' => '',
			        ),
		            array(
						'type' => 'textfield',
						'heading' => esc_html__('Price', 'conceptseven'),
						'param_name' => 'price',
						'value' => '',
						'description'	=> esc_html__('The price for this package.', 'conceptseven'),
		            ),
					array(
						'type' 		=> 'textarea',
						'heading' 	=> esc_html__('Term', 'conceptseven'),
						'param_name' 	=> 'text',
						'value' 		=> '',
					),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Features Padding', 'conceptseven'),
						'param_name' => 'features_padding',
						'value' => '',
			        ),
					array(
						'type' 		=> 'textarea',
						'heading' 	=> esc_html__('Features', 'conceptseven'),
						'param_name' 	=> 'features',
						'value' 		=> '',
					),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Button Content', 'conceptseven'),
						'param_name' => 'button_content',
						'value' => '',
			        ),
			        array(
						'type' => 'textfield',
						'heading' => esc_html__('Button Link (URL)', 'conceptseven'),
						'param_name' => 'button_url',
						'value' => '',
			        ),
		            array(
						'type' => 'textfield',
						'heading' => esc_html__('Button Rounded', 'conceptseven'),
						'param_name' => 'button_rounded',
						'value' => '',
						'description'	=> esc_html__('Ex: 30px', 'conceptseven'),
		            ),
					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Button Style', 'conceptseven' ),
						'param_name' => 'button_style',
						'value'      => array(
							'Background' => 'background',
							'Outline' => 'outline',
						),
						'std'		=> 'background',
					),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Button Text', 'conceptseven'),
						'param_name' => 'button_text',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Button Background', 'conceptseven'),
						'param_name' => 'button_background',
						'value' => '',
						'dependency' => array( 'element' => 'button_style', 'value' => 'background' ),
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Button Border', 'conceptseven'),
						'param_name' => 'button_border',
						'value' => '',
						'dependency' => array( 'element' => 'button_style', 'value' => 'outline' ),
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Button Text: Hover', 'conceptseven'),
						'param_name' => 'button_text_hover',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Button Background: Hover', 'conceptseven'),
						'param_name' => 'button_background_hover',
						'value' => '',
		            ),
		            array(
						'type' => 'colorpicker',
						'heading' => esc_html__('Button Border: Hover', 'conceptseven'),
						'param_name' => 'button_border_hover',
						'value' => '',
						'dependency' => array( 'element' => 'button_style', 'value' => 'outline' ),
		            ),
				)                
            ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'subheading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Switcher: Bottom Margin', 'conceptseven'),
				'param_name' => 'switcher_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
		)
	) );
} );

// Content Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_contentbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Content Box', 'conceptseven'),
		'description' => esc_html__('Content Box.', 'conceptseven'),
		'base' => 'contentbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'contentbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Background Image', 'conceptseven'),
				'param_name' => 'bg_image',
				'value' => '',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Position', 'conceptseven' ),
				'param_name'  => 'bg_position',
				'value'       => array(
					'Left Top' => 'lt',
					'Right Top' => 'rt',
					'Center Top' => 'ct',
					'Center Center' => 'cc',
					'Center Bottom'   => 'cb',
					'Left Bottom' => 'lb',
					'Right Bottom'   => 'rb',
				),
				'std'		=> 'lt',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Repeat', 'conceptseven' ),
				'param_name'  => 'bg_repeat',
				'value'       => array(
					'No Repeat' => 'no-repeat',
					'Repeat'   => 'repeat',
					'Repeat X'   => 'repeat-x',
					'Repeat Y'   => 'repeat-y',
				),
				'std'		=> 'no-repeat',
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Background Size', 'conceptseven' ),
				'param_name'  => 'bg_size',
				'value'       => array(
					'Auto' 	   => '',
					'Cover'        => 'cover',
				),
				'std'		=> '',
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            // Spacing
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'center',
				),
				'std'		=> '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'conceptseven'),
				'param_name' => 'width',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'description'	=> esc_html__('Ex: 600px', 'conceptseven'),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width on mobile', 'conceptseven'),
				'param_name' => 'mobile_width',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'description'	=> esc_html__('Ex: 400px', 'conceptseven'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'conceptseven'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'conceptseven'),
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding on mobile', 'conceptseven'),
				'param_name' => 'mobile_padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'conceptseven'),
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'conceptseven'),
				'param_name' => 'margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin on mobile', 'conceptseven'),
				'param_name' => 'mobile_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ), 
				'description'	=> esc_html__('Top Right Bottom Left. You can use % or px value.', 'conceptseven'),
	        ),
            // Design
			array(
				'type' => 'headings',
				'text' => esc_html__('Background', 'conceptseven'),
				'param_name' => 'heading_background',
				'group' => esc_html__( 'Design', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'conceptseven'),
				'param_name' => 'background_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'conceptseven' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Border', 'conceptseven'),
				'param_name' => 'heading_border',
				'group' => esc_html__( 'Design', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'conceptseven'),
				'param_name' => 'border_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'conceptseven'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'conceptseven'),
				'group' => esc_html__( 'Design', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Rounded', 'conceptseven'),
				'param_name' => 'heading_rounded',
				'group' => esc_html__( 'Design', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'conceptseven'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'conceptseven'),
				'group' => esc_html__( 'Design', 'conceptseven' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'conceptseven'),
				'param_name' => 'heading_shadow',
				'group' => esc_html__( 'Design', 'conceptseven' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'conceptseven' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Design', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'conceptseven'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Design', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'conceptseven'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Design', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'conceptseven'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Design', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'conceptseven'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Design', 'conceptseven' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'conceptseven'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Design', 'conceptseven' ),
            ),
	        // Hover
			array(
				'type' => 'headings',
				'text' => esc_html__('Background', 'conceptseven'),
				'param_name' => 'heading_background_hover',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'conceptseven'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Border', 'conceptseven'),
				'param_name' => 'heading_border_hover',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'conceptseven'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'conceptseven'),
				'param_name' => 'border_width_hover',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 0px 0px 1px 0px', 'conceptseven'),
				'group' => esc_html__( 'Hover', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Rounded', 'conceptseven'),
				'param_name' => 'heading_rounded_hover',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'conceptseven'),
				'param_name' => 'rounded_hover',
				'value' => '',
				'description'	=> esc_html__('Ex: 6px', 'conceptseven'),
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'conceptseven'),
				'param_name' => 'heading_shadow_hover',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'conceptseven' ),
				'param_name'  => 'inset_hover',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'conceptseven'),
				'param_name' => 'horizontal_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'conceptseven'),
				'param_name' => 'vertical_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'conceptseven'),
				'param_name' => 'blur_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'conceptseven'),
				'param_name' => 'spread_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'conceptseven'),
				'param_name' => 'shadow_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Transforms', 'conceptseven'),
				'param_name' => 'heading_transforms',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__('Translate X', 'conceptseven'),
				'param_name' => 'translatex',
				'value' => 0,
				'suffix' => 'px',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
		  	),
			array(
				'type' => 'number',
				'heading' => esc_html__('Translate Y', 'conceptseven'),
				'param_name' => 'translatey',
				'value' => 0,
				'suffix' => 'px',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
		  	),
        )
    ) );
} );

// Single Heading
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Single Heading', 'conceptseven' ),
        'description' => esc_html__('Displaying a single heading with some styles.', 'conceptseven'),
		'base'        => 'singleheading',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> '',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'conceptseven' ),
				'param_name' => 'heading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'conceptseven'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'conceptseven'),
				'param_name' => 'line_width',
				'value' => '40',
				'group' => esc_html__( 'Line', 'conceptseven' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'conceptseven'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Line', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'conceptseven'),
				'param_name' => 'line_color',
				'value' => '#265cdc',
				'group' => esc_html__( 'Line', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing Between', 'conceptseven'),
				'param_name' => 'heading_padding',
				'value' => '',
				'group' => esc_html__( 'Line', 'conceptseven' ),
				'description'	=> esc_html__('Spacing between the line and the text. Ex: 10px.', 'conceptseven'),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
		)
	) );
} );

// Headings
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Headings', 'conceptseven' ),
        'description' => esc_html__('Displaying awesome heading styles.', 'conceptseven'),
		'base'        => 'headings',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'conceptseven' ),
				'param_name' => 'heading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'conceptseven'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading Max-Width', 'conceptseven'),
				'param_name' => 'heading_width',
				'value' => '',
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Sub-Heading (Optional)', 'conceptseven' ),
				'param_name' => 'subheading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Sub-Heading Color', 'conceptseven'),
				'param_name' => 'subheading_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading Max-Width', 'conceptseven'),
				'param_name' => 'subheading_width',
				'value' => '',
            ),
			array(
				'type' 		=> 'textarea_html',
				'holder' => 'div',
				'heading' 	=> esc_html__('Extra Content', 'conceptseven'),
				'param_name' 	=> 'content',
				'value' 		=> '',
				'group' => esc_html__( 'Extra Content', 'conceptseven' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Extra Content Max-Width', 'conceptseven'),
				'param_name' => 'content_width',
				'value' => '',
				'group' => esc_html__( 'Extra Content', 'conceptseven' ),
            ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator', 'conceptseven' ),
				'param_name' => 'separator',
				'value'      => array(
					'No Separator' => '',
					'Line' => 'line',
					'Image' => 'image',
				),
				'std'		=> '',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Separator Position', 'conceptseven' ),
				'param_name' => 'sep_position',
				'value'      => array(
					'Top' => 'top',
					'Between Heading & Sub-Heading' => 'between',
					'Bottom' => 'bottom',
					'Left' => 'left',
				),
				'std'		=> 'between',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => array( 'line', 'image' ) ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'conceptseven'),
				'param_name' => 'line_width',
				'value' => '70',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'conceptseven'),
				'param_name' => 'line_height',
				'value' => '2',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Right Margin', 'conceptseven'),
				'param_name' => 'line_right_margin',
				'value' => '20',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
				'dependency' => array( 'element' => 'sep_position', 'value' => 'left' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'conceptseven'),
				'param_name' => 'line_color',
				'value' => '#265cdc',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'line' ),
            ),
	        // Image
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'conceptseven'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Image Width (Optional)', 'conceptseven'),
				'param_name' => 'image_width',
				'value' => '',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
				'dependency' => array( 'element' => 'separator', 'value' => 'image' ),
	        ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'conceptseven' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size on Mobile', 'conceptseven'),
				'param_name' => 'heading_font_size_mobile',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'conceptseven'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Sub-Heading', 'conceptseven'),
				'param_name' => 'subheading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Family', 'conceptseven' ),
				'param_name' => 'subheading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Weight', 'conceptseven' ),
				'param_name' => 'subheading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Font Size', 'conceptseven'),
				'param_name' => 'subheading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Line Height', 'conceptseven'),
				'param_name' => 'subheading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Sub-Heading: Font Style', 'conceptseven' ),
				'param_name' => 'subheading_font_style',
				'value'      => array(
					'Normal' => 'normal',
					'Italic' => 'italic',
				),
				'std'		=> 'normal',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'conceptseven'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Top Margin', 'conceptseven'),
				'param_name' => 'subheading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Sub-Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'subheading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
		)
	) );
} );

// Step Box
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Step Box', 'conceptseven' ),
        'description' => esc_html__('Displaying step boxes.', 'conceptseven'),
		'base'        => 'stepbox',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Number Step', 'conceptseven' ),
				'param_name' => 'number',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Number Color', 'conceptseven'),
				'param_name' => 'number_color',
				'value' => '',
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'conceptseven' ),
				'param_name' => 'heading',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'conceptseven'),
				'param_name' => 'heading_color',
				'value' => '',
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Description', 'conceptseven' ),
				'param_name' => 'desc',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'conceptseven'),
				'param_name' => 'desc_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'thecraft'),
				'param_name' => 'line_width',
				'value' => '100',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'thecraft'),
				'param_name' => 'line_height',
				'value' => '2',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'thecraft'),
				'param_name' => 'line_color',
				'value' => '',
            ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Number', 'conceptseven'),
				'param_name' => 'number_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Family', 'conceptseven' ),
				'param_name' => 'number_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Weight', 'conceptseven' ),
				'param_name' => 'number_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Font Size', 'conceptseven'),
				'param_name' => 'number_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Line Height', 'conceptseven'),
				'param_name' => 'number_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading', 'conceptseven'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'conceptseven' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'conceptseven'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Description', 'conceptseven'),
				'param_name' => 'desc_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description: Font Family', 'conceptseven' ),
				'param_name' => 'desc_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Description: Font Weight', 'conceptseven' ),
				'param_name' => 'desc_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Font Size', 'conceptseven'),
				'param_name' => 'desc_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Line Height', 'conceptseven'),
				'param_name' => 'desc_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'conceptseven'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Top Margin', 'conceptseven'),
				'param_name' => 'desc_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Description: Bottom Margin', 'conceptseven'),
				'param_name' => 'desc_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
		)
	) );
} );

// Text Group
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Text Group', 'conceptseven' ),
        'description' => esc_html__('Displaying texts group.', 'conceptseven'),
		'base'        => 'textgroup',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 1', 'conceptseven' ),
				'param_name' => 'text1',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 1 Color', 'conceptseven'),
				'param_name' => 'text1_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1 Max-Width', 'conceptseven'),
				'param_name' => 'text1_width',
				'value' => '',
            ),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 2', 'conceptseven' ),
				'param_name' => 'text2',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 2 Color', 'conceptseven'),
				'param_name' => 'text2_color',
				'value' => '',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2 Max-Width', 'conceptseven'),
				'param_name' => 'text2_width',
				'value' => '',
            ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 1', 'conceptseven'),
				'param_name' => 'text1_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Family', 'conceptseven' ),
				'param_name' => 'text1_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Weight', 'conceptseven' ),
				'param_name' => 'text1_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Font Size', 'conceptseven'),
				'param_name' => 'text1_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Line Height', 'conceptseven'),
				'param_name' => 'text1_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 2', 'conceptseven'),
				'param_name' => 'text2_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Family', 'conceptseven' ),
				'param_name' => 'text2_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Weight', 'conceptseven' ),
				'param_name' => 'text2_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2: Font Size', 'conceptseven'),
				'param_name' => 'text2_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2: Line Height', 'conceptseven'),
				'param_name' => 'text2_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Bottom Margin', 'conceptseven'),
				'param_name' => 'text1_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
		)
	) );
} );

// Animation Block
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_animationblock extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Animation Block', 'conceptseven'),
		'description' => esc_html__('Apply animations anywhere.', 'conceptseven'),
		'base' => 'animationblock',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'animationblock'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
         )
    ) );
} );

// Counter
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Counter', 'conceptseven' ),
        'description' => esc_html__('Displaying a counter.', 'conceptseven'),
		'base'        => 'counter',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Order', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'No Icon' => 'no-icon',
					'Icon Top' => 'icon-top',
					'Icon Left' => 'icon-left',
				),
				'std'		=> 'no-icon',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Order', 'conceptseven' ),
				'param_name' => 'order',
				'value'      => array(
					'Number & Heading' => 'nh',
					'Heading & Number' => 'hn',
				),
				'std'		=> 'nh',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
				'dependency' => array( 'element' => 'style', 'value' => array('no-icon','icon-top')  ),
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'conceptseven' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'conceptseven' ),
				'value' => array(
					esc_html__( '', 'conceptseven' ) => '',
					esc_html__( 'Elegant Icons', 'conceptseven' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'conceptseven' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'conceptseven' ) => 'openiconic',
					esc_html__( 'Typicons', 'conceptseven' ) => 'typicons',
					esc_html__( 'Entypo', 'conceptseven' ) => 'entypo',
					esc_html__( 'Linecons', 'conceptseven' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'conceptseven' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'conceptseven'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'conceptseven'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Line-Height', 'conceptseven'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-top','icon-left')  ),
	        ),
			// Number
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number Tag', 'conceptseven' ),
				'param_name' => 'number_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'h3',
				'group' => esc_html__( 'Number', 'conceptseven' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Number', 'conceptseven' ),
				'param_name' => 'number',
				'group' => esc_html__( 'Number', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Number Color', 'conceptseven'),
				'param_name' => 'number_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'conceptseven' ),
            ),
			array(
				'type' => 'number',
				'heading' => esc_html__('Rolling Time', 'conceptseven'),
				'param_name' => 'time',
				'value' => 5000,
				'suffix' => 'ms',
				'group' => esc_html__( 'Number', 'conceptseven' ),
		  	),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Prefix (Optional)', 'conceptseven' ),
				'param_name' => 'number_prefix',
				'group' => esc_html__( 'Number', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Color', 'conceptseven'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'conceptseven' ),
            ),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Suffix (Optional)', 'conceptseven' ),
				'param_name' => 'number_suffix',
				'group' => esc_html__( 'Number', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Color', 'conceptseven'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Number', 'conceptseven' ),
            ),
		  	// Heading
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading Tag', 'conceptseven' ),
				'param_name' => 'heading_tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
					'div' => 'div',
				),
				'std'		=> 'div',
				'group' => esc_html__( 'Heading', 'conceptseven' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading', 'conceptseven' ),
				'param_name' => 'heading',
				'group' => esc_html__( 'Heading', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Heading Color', 'conceptseven'),
				'param_name' => 'heading_color',
				'value' => '',
				'group' => esc_html__( 'Heading', 'conceptseven' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Width', 'conceptseven'),
				'param_name' => 'line_width',
				'value' => '',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line Height', 'conceptseven'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line Color', 'conceptseven'),
				'param_name' => 'line_color',
				'value' => '',
				'group' => esc_html__( 'Separator', 'conceptseven' ),
            ),
	        // Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Number Settings', 'conceptseven'),
				'param_name' => 'number_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Family', 'conceptseven' ),
				'param_name' => 'number_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Number: Font Weight', 'conceptseven' ),
				'param_name' => 'number_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Font Size', 'conceptseven'),
				'param_name' => 'number_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Line Height', 'conceptseven'),
				'param_name' => 'number_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Letter Spacing', 'conceptseven'),
				'param_name' => 'number_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type' => 'headings',
				'text' => esc_html__('Heading Settings', 'conceptseven'),
				'param_name' => 'heading_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
				'class' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Family', 'conceptseven' ),
				'param_name' => 'heading_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Heading: Font Weight', 'conceptseven' ),
				'param_name' => 'heading_font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Font Size', 'conceptseven'),
				'param_name' => 'heading_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Line Height', 'conceptseven'),
				'param_name' => 'heading_line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Letter Spacing', 'conceptseven'),
				'param_name' => 'heading_letter_spacing',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Top Margin', 'conceptseven'),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-left')  ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Margin', 'conceptseven'),
				'param_name' => 'icon_right_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
				'dependency' => array( 'element' => 'style', 'value' => array('icon-left')  ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Top Margin', 'conceptseven'),
				'param_name' => 'number_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number: Bottom Margin', 'conceptseven'),
				'param_name' => 'number_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Top Margin', 'conceptseven'),
				'param_name' => 'heading_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Heading: Bottom Margin', 'conceptseven'),
				'param_name' => 'heading_bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
		)
	) );
} );

// Video Icon
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Video Icon', 'conceptseven' ),
        'description' => esc_html__('Displaying Icon with custom video popup.', 'conceptseven'),
		'base'        => 'videoicon',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'thecraft' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Light' => 'white',
					'Accent' => 'accent',
				),
				'std'		=> 'white',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Link Youtube/Vimeo (URL)', 'conceptseven'),
				'param_name' => 'video_url',
				'value' => '',
	        ),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
		)
	) );
} );

// Simple Image
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Simple Image', 'conceptseven' ),
        'description' => esc_html__('Displaying a simple image with animation.', 'conceptseven'),
		'base'        => 'simpleimage',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'conceptseven'),
				'param_name' => 'image',
				'value' => '',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
				'dependency' => array( 'element' => 'style', 'value' => 'style-1' ),
			),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'conceptseven'),
				'param_name' => 'url',
				'value' => '',
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'conceptseven' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
            // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
		)
	) );
} );

// Parallax Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_parallaxbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Parallax Box', 'conceptseven'),
		'description' => esc_html__('Parallax Box.', 'conceptseven'),
		'base' => 'parallaxbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'parallaxbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
	        array(
	            "type" => "dropdown",
	            "heading" => esc_html__('Top Padding', 'conceptseven'),
	            "param_name" => "top_padding",
	            'value' => array(
	                esc_html__( 'Default', 'conceptseven' ) => '',
	                '-250px' => '-250px',
	                '-240px' => '-240px',
	                '-230px' => '-230px',
	                '-220px' => '-220px',
	                '-210px' => '-210px',
	                '-200px' => '-200px',
	                '-190px' => '-190px',
	                '-180px' => '-180px',
	                '-170px' => '-170px',
	                '-160px' => '-160px',
	                '-150px' => '-150px',
	                '-140px' => '-140px',
	                '-130px' => '-130px',
	                '-120px' => '-120px',
	                '-110px' => '-110px',
	                '-100px' => '-100px',
	                '-90px' => '-90px',
	                '-80px' => '-80px',
	                '-70px' => '-70px',
	                '-60px' => '-60px',
	                '-50px' => '-50px',
	                '-40px' => '-40px',
	                '-30px' => '-30px',
	                '30px' => '30px',
	                '40px' => '40px',
	                '50px' => '50px',
	                '60px' => '60px',
	                '70px' => '70px',
	                '80px' => '80px',
	                '90px' => '90px',
	                '100px' => '100px',
	                '110px' => '110px',
	                '120px' => '120px',
	                '130px' => '130px',
	                '140px' => '140px',
	                '150px' => '150px',
	                '160px' => '160px',
	                '170px' => '170px',
	                '180px' => '180px',
	                '190px' => '190px',
	                '200px' => '200px',
	                '210px' => '210px',
	                '220px' => '220px',
	                '230px' => '230px',
	                '240px' => '240px',
	                '250px' => '250px',
	            ),     
	        ),
	        array(
	            "type" => "dropdown",
	            "heading" => esc_html__('Left Padding', 'conceptseven'),
	            "param_name" => "left_padding",
	            'value' => array(
	                esc_html__( 'Default', 'conceptseven' ) => '',
	                '-250px' => '-250px',
	                '-240px' => '-240px',
	                '-230px' => '-230px',
	                '-220px' => '-220px',
	                '-210px' => '-210px',
	                '-200px' => '-200px',
	                '-190px' => '-190px',
	                '-180px' => '-180px',
	                '-170px' => '-170px',
	                '-160px' => '-160px',
	                '-150px' => '-150px',
	                '-140px' => '-140px',
	                '-130px' => '-130px',
	                '-120px' => '-120px',
	                '-110px' => '-110px',
	                '-100px' => '-100px',
	                '-90px' => '-90px',
	                '-80px' => '-80px',
	                '-70px' => '-70px',
	                '-60px' => '-60px',
	                '-50px' => '-50px',
	                '50px' => '50px',
	                '60px' => '60px',
	                '70px' => '70px',
	                '80px' => '80px',
	                '90px' => '90px',
	                '100px' => '100px',
	                '110px' => '110px',
	                '120px' => '120px',
	                '130px' => '130px',
	                '140px' => '140px',
	                '150px' => '150px',
	                '160px' => '160px',
	                '170px' => '170px',
	                '180px' => '180px',
	                '190px' => '190px',
	                '200px' => '200px',
	                '210px' => '210px',
	                '220px' => '220px',
	                '230px' => '230px',
	                '240px' => '240px',
	                '250px' => '250px',
	            ),     
	        ),
	        array(
	            'type' => 'textfield',
	            'heading' => esc_html__('Parallax X', 'conceptseven'),
	            'param_name' => 'parallax_x',
	            'description'   => esc_html__('X axis translation.', 'conceptseven'),
	        ),
	        array(
	            'type' => 'textfield',
	            'heading' => esc_html__('Parallax Y', 'conceptseven'),
	            'param_name' => 'parallax_y',
	            'description'   => esc_html__('Y axis translation.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Max Width', 'conceptseven'),
				'param_name' => 'width',
				'value' => '',
				'description'	=> esc_html__('You can use % or px value. Ex: 50%.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'conceptseven'),
				'param_name' => 'margin',
				'value' => '',
	        ),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'conceptseven'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Link URL', 'conceptseven' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'conceptseven' ),
				'param_name' => 'new_tab',
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
				'group' => esc_html__( 'Link URL', 'conceptseven' ),
			),
        )
    ) );
} );

// Icons
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Icons', 'conceptseven' ),
        'description' => esc_html__('Displaying Icon lists with custom icon.', 'conceptseven'),
		'base'        => 'icons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Background' => 'background',
					'Outline' => 'outline',
				),
				'std'		=> 'background',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Width', 'conceptseven'),
				'param_name' => 'width',
				'value' => '60',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Height', 'conceptseven'),
				'param_name' => 'height',
				'value' => '60',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'conceptseven'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'conceptseven'),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'conceptseven'),
				'param_name' => 'icon_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'conceptseven'),
				'param_name' => 'background_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'background' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'conceptseven'),
				'param_name' => 'border_color',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'conceptseven'),
				'param_name' => 'border_width',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'conceptseven'),
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'conceptseven' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color: Hover', 'conceptseven'),
				'param_name' => 'icon_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color: Hover', 'conceptseven'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color: Hover', 'conceptseven'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'dependency' => array( 'element' => 'style', 'value' => 'outline' ),
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'conceptseven'),
				'param_name' => 'margin',
				'value' => '',
	        ),
			// Icon
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'conceptseven' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'conceptseven' ),
				'value' => array(
					esc_html__( '', 'conceptseven' ) => '',
					esc_html__( 'Elegant Icons', 'conceptseven' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'conceptseven' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'conceptseven' ) => 'openiconic',
					esc_html__( 'Typicons', 'conceptseven' ) => 'typicons',
					esc_html__( 'Entypo', 'conceptseven' ) => 'entypo',
					esc_html__( 'Linecons', 'conceptseven' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'conceptseven' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Font Size', 'conceptseven'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Line Height', 'conceptseven'),
				'param_name' => 'icon_line_height',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
	        ),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'conceptseven'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'conceptseven' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'conceptseven' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'conceptseven' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
		)
	) );
} );

// Divider
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Divider', 'conceptseven'),
        'description' => esc_html__('Displaying lines separator.', 'conceptseven'),
        'base' => 'divider',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'divider-left',
					'Center' => 'divider-center',
					'Right' => 'divider-right',
				),
				'std'		=> 'divider-center',
				'dependency' => array( 'element' => 'icon_display', 'value' => 'no-icon' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Line Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed',
					'Double' => 'double',
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Width', 'conceptseven'),
				'param_name' => 'width',
				'value' => '',
				'description' => esc_html__( 'Default: 100%.', 'conceptseven' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Height', 'conceptseven'),
				'param_name' => 'height',
				'value' => '',
				'description'	=> esc_html__('Default: 1px', 'conceptseven'),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Line: Color', 'conceptseven'),
				'param_name' => 'color',
				'value' => '',
            ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon to Display', 'conceptseven' ),
				'param_name' => 'icon_display',
				'value'      => array(
					'No Icon' => 'no-icon',
					'Icon Font' => 'icon-font',
				),
				'std'		=> 'no-icon',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'conceptseven' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'conceptseven' ),
				'value' => array(
					esc_html__( '', 'conceptseven' ) => '',
					esc_html__( 'Elegant Icons', 'conceptseven' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'conceptseven' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'conceptseven' ) => 'openiconic',
					esc_html__( 'Typicons', 'conceptseven' ) => 'typicons',
					esc_html__( 'Entypo', 'conceptseven' ) => 'entypo',
					esc_html__( 'Linecons', 'conceptseven' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'conceptseven' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon: Color', 'conceptseven'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Font Size', 'conceptseven'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Padding', 'conceptseven'),
				'param_name' => 'icon_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'description'	=> esc_html__('Top Right Bottom Left. Default: 0px 12px 0px 12px', 'conceptseven'),
				'dependency' => array( 'element' => 'icon_display', 'value' => 'icon-font' ),
	        ),
	        // Spacing
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Top Margin', 'conceptseven'),
				'param_name' => 'icon_top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Top Margin', 'conceptseven'),
				'param_name' => 'top_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line: Bottom Margin', 'conceptseven'),
				'param_name' => 'bottom_margin',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
	        ),
        )
    ) );
} );

// Alignment Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_alignbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Alignment Box', 'conceptseven' ),
        'description' => esc_html__('Align elements.', 'conceptseven'),
		'base'        => 'alignbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'alignbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Right' => 'text-right',
					'Center' => 'text-center',
				),
				'std'		=> 'text-center',
			),
		)
	) );
} );

// Grid Box
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_gridbox extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
		'name' => esc_html__('Grid Box', 'conceptseven'),
		'description' => esc_html__('Grid Box.', 'conceptseven'),
		'base' => 'gridbox',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'gridbox'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Grid 4' => '4',
					'Grid 3' => '3',
					'Grid 2' => '2',
				),
				'std'		=> '3',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Style', 'conceptseven' ),
				'param_name' => 'border_style',
				'value' => array(
					'Full' => 'full',
					'Half' => 'half',
				),
				'std'		=> 'full',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Color', 'conceptseven' ),
				'param_name' => 'border_color',
				'value' => array(
					'Light' => 'light',
					'Dark' => 'dark',
					'Very Light' => 'verylight',
				),
				'std'		=> 'light',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Border Wrap?', 'conceptseven' ),
				'param_name' => 'wrap',
				'value' => array(
					'Yes' => 'true',
					'No' => 'false',
				),
				'std'		=> 'true',
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Buttons
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Buttons', 'conceptseven'),
        'description' => esc_html__('Advanced Buttons.', 'conceptseven'),
        'base' => 'buttons',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
            array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__('Text', 'conceptseven'),
				'param_name' => 'text',
				'value' => 'Button Text',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Size', 'conceptseven' ),
				'param_name' => 'size',
				'value'      => array(
					'Medium' => 'medium',
					'Small' => 'small',
					'Big' => 'big',
				),
				'std'		=> 'medium',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'conceptseven'),
				'param_name' => 'text_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color', 'conceptseven'),
				'param_name' => 'background_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color', 'conceptseven'),
				'param_name' => 'border_color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Border Width', 'conceptseven'),
				'param_name' => 'border_width',
				'value' => '1px',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Border Style', 'conceptseven' ),
				'param_name' => 'border_style',
				'value'      => array(
					'Solid' => 'solid',
					'Dotted' => 'dotted',
					'Dashed' => 'dashed'
				),
				'std'		=> 'solid',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Rounded', 'conceptseven'),
				'param_name' => 'rounded',
				'value' => '',
				'description'	=> esc_html__('ex: 10px', 'conceptseven'),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Padding', 'conceptseven'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Ex: 13px 40px 13px 40px', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Margin', 'conceptseven'),
				'param_name' => 'margin',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left.', 'conceptseven'),
	        ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Full-width Button?', 'conceptseven' ),
				'param_name' => 'full_width',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
	        // Animation
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Enable Animation?', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation_effect',
				'value'      => array(
					'Fade In Up' => 'fadeInUp',
					'Fade In Down' => 'fadeInDown',
					'Fade In' => 'fadeIn',
					'Fade In Left' => 'fadeInLeft',
					'Fade In Right' => 'fadeInRight',
				),
				'std'		=> 'fadeInUp',
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Duration', 'conceptseven'),
				'param_name' => 'animation_duration',
				'value' => '0.75s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Animation Delay', 'conceptseven'),
				'param_name' => 'animation_delay',
				'value' => '0.3s',
				'description'	=> esc_html__('Ex: 0.1s, 0.15s', 'conceptseven'),
				'dependency' => array( 'element' => 'animation', 'value' => 'yes' ),
            ),
			// Hover
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color: Hover', 'conceptseven'),
				'param_name' => 'text_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Background Color: Hover', 'conceptseven'),
				'param_name' => 'background_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Border Color: Hover', 'conceptseven'),
				'param_name' => 'border_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color: Hover', 'conceptseven'),
				'param_name' => 'icon_color_hover',
				'value' => '',
				'group' => esc_html__( 'Hover', 'conceptseven' ),
				'dependency' => array( 'element' => 'show_icon', 'value' => 'yes' ),
            ),
			// Icon
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Style', 'conceptseven' ),
				'param_name' => 'icon_style',
				'value'      => array(
					'No Icon' => 'no_icon',
					'Icon Style 1' => 'icon_style_1',
					'Icon Style 2' => 'icon_style_2',
					'Custom Icon' => 'custom',
				),
				'std'		=> 'no_icon',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'conceptseven' ),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'conceptseven' ),
				'value' => array(
					esc_html__( '', 'conceptseven' ) => '',
					esc_html__( 'Elegant Icons', 'conceptseven' ) => 'extraicon',
					esc_html__( 'FontAwesome', 'conceptseven' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'conceptseven' ) => 'openiconic',
					esc_html__( 'Typicons', 'conceptseven' ) => 'typicons',
					esc_html__( 'Entypo', 'conceptseven' ) => 'entypo',
					esc_html__( 'Linecons', 'conceptseven' ) => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
			array(
			    'type' => 'iconpicker',
			    'heading' => esc_html__( 'Icon', 'conceptseven' ),
			    'param_name' => 'icon_extraicon',
			    'settings' => array(
			        'emptyIcon' => true,
			        'type' => 'extraicon',
			        'iconsPerPage' => 200,
			    ),
			    'dependency' => array(
			        'element' => 'icon_type',
			        'value' => 'extraicon',
			    ),
			    'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon',
				'settings' => array(
					'emptyIcon' => true,
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_openiconic',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'openiconic',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_typicons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'typicons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_entypo',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'entypo',
					'iconsPerPage' => 300,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'conceptseven' ),
				'param_name' => 'icon_linecons',
				'settings' => array(
					'emptyIcon' => true,
					'type' => 'linecons',
					'iconsPerPage' => 200,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'group' => esc_html__( 'Icon', 'conceptseven' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'conceptseven'),
				'param_name' => 'icon_color',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Font Size', 'conceptseven'),
				'param_name' => 'icon_font_size',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon Position', 'conceptseven' ),
				'param_name' => 'icon_position',
				'value'      => array(
					'Icon Left' => 'icon-left',
					'Icon Right' => 'icon-right',
				),
				'std'		=> 'icon-right',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon: Right Padding', 'conceptseven'),
				'param_name' => 'icon_right_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'conceptseven'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-left' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Icon Left Padding', 'conceptseven'),
				'param_name' => 'icon_left_padding',
				'value' => '',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'description'	=> esc_html__('Spacing between the icon and the text. Ex: 40px.', 'conceptseven'),
				'dependency' => array( 'element' => 'icon_position', 'value' => 'icon-right' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Icon: Offset', 'conceptseven' ),
				'param_name' => 'icon_offset',
				'value'      => array(
					'-15px' => '-15',
					'-14px' => '-14',
					'-13px' => '-13',
					'-12px' => '-12',
					'-11px' => '-11',
					'-10px' => '-10',
					'-9px' => '-9',
					'-8px' => '-8',
					'-7px' => '-7',
					'-6px' => '-6',
					'-5px' => '-5',
					'-4px' => '-4',
					'-3px' => '-3',
					'-2px' => '-2',
					'-1px' => '-1',
					'0px' => '0',
					'1px' => '1',
					'2px' => '2',
					'3px' => '3',
					'4px' => '4',
					'5px' => '5',
					'6px' => '6',
					'7px' => '7',
					'8px' => '8',
					'9px' => '9',
					'10px' => '10',
					'11px' => '11',
					'12px' => '12',
					'13px' => '13',
					'14px' => '14',
					'15px' => '15',
				),
				'std'		=> '0px',
				'group' => esc_html__( 'Icon', 'conceptseven' ),
				'description'	=> esc_html__('Use this to change the distance middle the icon and top of button.', 'conceptseven'),
				'dependency' => array( 'element' => 'icon_style', 'value' => 'custom' ),
			),
	        // Hyperlink
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Link (URL):', 'conceptseven'),
				'param_name' => 'link_url',
				'value' => '',
				'group' => esc_html__( 'Hyperlink', 'conceptseven' ),
            ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Open Link in a new Tab', 'conceptseven' ),
				'param_name' => 'new_tab',
				'group' => esc_html__( 'Hyperlink', 'conceptseven' ),
				'value' => array(
					'Yes' => 'yes',
					'No' => 'no',
				),
				'std'		=> 'yes',
			),
			// Box Shadow
			array(
				'type' => 'headings',
				'text' => esc_html__('Box Shadow', 'conceptseven'),
				'param_name' => 'heading_shadow',
				'group' => esc_html__( 'Box Shadow', 'conceptseven' ),
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Option Shadow', 'conceptseven' ),
				'param_name'  => 'inset',
				'value'       => array(
					'Outset'   => '',
					'Inset'   => 'inset',
				),
				'std'		=> '',
				'group' => esc_html__( 'Box Shadow', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Horizontal (Required)', 'conceptseven'),
				'param_name' => 'horizontal',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Vertical (Required)', 'conceptseven'),
				'param_name' => 'vertical',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Blur (Required)', 'conceptseven'),
				'param_name' => 'blur',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spread (Required)', 'conceptseven'),
				'param_name' => 'spread',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'conceptseven' ),
	        ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Shadow Color (Required)', 'conceptseven'),
				'param_name' => 'shadow_color',
				'value' => '',
				'group' => esc_html__( 'Box Shadow', 'conceptseven' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'conceptseven' ),
				'param_name' => 'font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'conceptseven' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Font Size', 'conceptseven'),
				'param_name' => 'font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Line-Height', 'conceptseven'),
				'param_name' => 'line_height',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
        )
    ) );
} );

// Hero Section
add_action( 'vc_before_init', function() {
    class WPBakeryShortCode_hero extends WPBakeryShortCodesContainer {}
} );
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Hero Section', 'conceptseven'),
        'description' => esc_html__('Hero Section.', 'conceptseven'),
        'base' => 'hero',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
		'as_parent' => array('except' => 'hero'),
		'controls' => 'full',
		'show_settings_on_create' => true,
		'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Hero Height', 'conceptseven' ),
				'param_name' => 'hero_height',
				'value'      => array(
					'Full Screen' => 'full-height',
					'Custom Height' => 'custom-height',
				),
				'std'		=> 'full-height',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Hero Custom Height', 'conceptseven'),
				'param_name' => 'hero_custom_height',
				'value' => '',
				'description'	=> esc_html__('Ex: 600px.', 'conceptseven'),
				'dependency' => array( 'element' => 'hero_height', 'value' => 'custom-height' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Showcase', 'conceptseven' ),
				'param_name' => 'showcase',
				'value'      => array(
					'Background Slideshow' => 'slideshow',
					'Background Video' => 'video',
				),
				'std'		=> 'slideshow',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Background Images', 'conceptseven'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for background slideshow.', 'conceptseven'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Effects', 'conceptseven' ),
				'param_name' => 'effect',
				'value'      => array(
					'fade' => 'fade',
					'fade2' => 'fade2',
					'slideLeft' => 'slideLeft',
					'slideLeft2' => 'slideLeft2',
					'slideRight' => 'slideRight',
					'slideRight2' => 'slideRight2',
					'slideUp' => 'slideUp',
					'slideDown' => 'slideDown',
					'slideDown2' => 'slideDown2',
					'zoomIn' => 'zoomIn',
					'zoomIn2' => 'zoomIn2',
					'zoomOut' => 'zoomOut',
					'zoomOut2' => 'zoomOut2',
					'swirlLeft' => 'swirlLeft',
					'swirlLeft2' => 'swirlLeft2',
					'swirlRight' => 'swirlRight',
					'swirlRight2' => 'swirlRight2',
					'burn' => 'burn',
					'burn2' => 'burn2',
					'blur' => 'blur',
					'blur2' => 'blur2',
					'flash' => 'flash',
					'flash2' => 'flash2'
				),
				'std'		=> 'fade',
				'dependency' => array( 'element' => 'showcase', 'value' => 'slideshow' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Youtube link (URL)', 'conceptseven'),
				'param_name' => 'video_link',
				'value' => '',
				'description' => esc_html__('Youtube link or ID. Ex: https://www.youtube.com/watch?v=vQqZIFCab9o', 'conceptseven'),
				'dependency' => array( 'element' => 'showcase', 'value' => 'video' ),
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Pattern Overlay', 'conceptseven' ),
				'param_name' => 'pattern_overlay',
				'value'      => array(
					'No Parttern' => '',
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
					'Style 3' => 'style-3',
					'Style 4' => 'style-4',
					'Style 5' => 'style-5',
					'Style 6' => 'style-6',
					'Style 7' => 'style-7',
					'Style 8' => 'style-8',
					'Style 9' => 'style-9',
				),
				'std'		=> 'style-1',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color Overlay', 'conceptseven'),
				'param_name' => 'color_overlay',
				'value' => '',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Content Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Content: Top Margin', 'conceptseven'),
				'param_name' => 'content_top',
				'value' => '',
				'description'	=> esc_html__('Ex: 50px. In case you want to set a spacing above the content area.', 'conceptseven'),
            ),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Content area into Grid?', 'conceptseven' ),
				'param_name' => 'grid',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			// Arrow
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show arrow?', 'conceptseven' ),
				'param_name' => 'scroll',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
				'group' => esc_html__( 'Arrow', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrow Style', 'conceptseven' ),
				'param_name' => 'arrow_style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
				'group' => esc_html__( 'Arrow', 'conceptseven' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Scroll to Row (ID)', 'conceptseven'),
				'param_name' => 'scroll_id',
				'value' => '',
				'description' => esc_html__('Enter the anchor ID you assigned to the element.', 'conceptseven'),
				'group' => esc_html__( 'Arrow', 'conceptseven' ),
				'dependency' => array( 'element' => 'scroll', 'value' => 'yes' ),
            ),
        )
    ) );
} );

// Images Slider or Grid
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name' => esc_html__( 'Images Slider or Grid', 'conceptseven' ),
		'description' => esc_html__('Displaying images in slider, masonry or mosaic grid.', 'conceptseven'),
		'base' => 'imagesgrid',
		'weight'	=>	180,
		'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Layout', 'conceptseven' ),
				'param_name' => 'mode',
				'value'      => array(
					'Slider' => 'slider',
					'Masonry' => 'grid',
					'Masonry' => 'mosaic',
				),
				'std'		=> 'slider',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Image Cropping', 'conceptseven' ),
				'param_name' => 'image_crop',
				'value'      => array(
					'Full' => 'full',
					'600 x 600' => 'square',
					'600 x 500' => 'rectangle',
				),
				'std'		=> 'square',
			),
			array(
				'type' => 'attach_images',
				'heading' => esc_html__('Images', 'conceptseven'),
				'param_name' => 'images',
				'value' => '',
				'description' => esc_html__('Choose multi-images for Images Grid.', 'conceptseven')
			),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'conceptseven'),
				'param_name' => 'gapv',
				'value' => '0',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing below items', 'conceptseven'),
				'param_name' => 'gaph',
				'value' => '0',
            ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap > 1100px.', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Column Options', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '4c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 800px to 1099px.', 'conceptseven' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Column Options', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap from 550px to 799px.', 'conceptseven' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Column Options', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'If Wrap < 549px.', 'conceptseven' ),
				'param_name' => 'column4',
				'group'      => esc_html__( 'Column Options', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
		)
	) );
} );

// Scroll Target
add_action( 'vc_before_init', function() {
	vc_map( array(
		'name'        => esc_html__( 'Scroll to ID Target', 'conceptseven' ),
        'description' => esc_html__('Displaying a arrow for scrolling down when clicked.', 'conceptseven'),
		'base'        => 'scrolltarget',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
		'params'      => array(
            array(
				'type' => 'textfield',
				'heading' => esc_html__('ID Target', 'conceptseven'),
				'param_name' => 'id_target',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Color', 'conceptseven'),
				'param_name' => 'color',
				'value' => '',
            ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Size', 'conceptseven'),
				'param_name' => 'size',
				'value' => '',
	        ),
		)
	) );
} );

// Special Text
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Special Text', 'conceptseven'),
        'description' => esc_html__('Awesome Texts.', 'conceptseven'),
        'base' => 'specialtext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => 'text-left',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-left',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'conceptseven' ),
				'param_name' => 'tag',
				'value'      => array(
					'Div' => 'div',
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'div',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 1 (Optional)', 'conceptseven' ),
				'param_name' => 'text1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 2 (Optional)', 'conceptseven' ),
				'param_name' => 'text2',
			),
			array(
				'type' => 'textfield',
				'holder' => 'span',
				'heading' => esc_html__( 'Text 3 (Optional)', 'conceptseven' ),
				'param_name' => 'text3',
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 1 Color', 'conceptseven'),
				'param_name' => 'color1',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 2 Color', 'conceptseven'),
				'param_name' => 'color2',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text 3 Color', 'conceptseven'),
				'param_name' => 'color3',
				'value' => '',
            ),
			// Typography
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 1', 'conceptseven'),
				'param_name' => 'text1_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Family', 'conceptseven' ),
				'param_name' => 'text1_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Weight', 'conceptseven' ),
				'param_name' => 'text1_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Font Size', 'conceptseven'),
				'param_name' => 'text1_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 1: Font Style', 'conceptseven' ),
				'param_name' => 'text1_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 2', 'conceptseven'),
				'param_name' => 'text2_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Family', 'conceptseven' ),
				'param_name' => 'text2_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Weight', 'conceptseven' ),
				'param_name' => 'text2_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2: Font Size', 'conceptseven'),
				'param_name' => 'text2_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 2: Font Style', 'conceptseven' ),
				'param_name' => 'text2_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Text 3', 'conceptseven'),
				'param_name' => 'text3_typograpy',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Family', 'conceptseven' ),
				'param_name' => 'text3_font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Weight', 'conceptseven' ),
				'param_name' => 'text3_font_weight',
				'value'      => array(
					'Default' => 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 3: Font Size', 'conceptseven'),
				'param_name' => 'text3_font_size',
				'value' => '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text 3: Font Style', 'conceptseven' ),
				'param_name' => 'text3_font_style',
				'value'      => array(
					'Normal' => '',
					'Italic' => 'italic',
				),
				'std'		=> '',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			// Spacing
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 1: Right Padding', 'conceptseven'),
				'param_name' => 'text1_right_padding',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Text 2: Right Padding', 'conceptseven'),
				'param_name' => 'text2_right_padding',
				'value' => '',
				'group' => esc_html__( 'Spacing', 'conceptseven' ),
            ),
        )
    ) );
} );

// Fancy Text
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Fancy Text', 'conceptseven'),
        'description' => esc_html__('Awesome Animation Text.', 'conceptseven'),
        'base' => 'fancytext',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Text Alignment', 'conceptseven' ),
				'param_name' => 'alignment',
				'value'      => array(
					'Left' => '',
					'Center' => 'text-center',
					'Right' => 'text-right',
				),
				'std'		=> 'text-center',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Animation', 'conceptseven' ),
				'param_name' => 'animation',
				'value'      => array(
					'Scrolling' => 'scroll',
					'Typing' => 'typed',
				),
				'std'		=> 'scroll',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 1 (Optional)', 'conceptseven' ),
				'param_name' => 'text1',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 2 (Optional)', 'conceptseven' ),
				'param_name' => 'text2',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 3 (Optional)', 'conceptseven' ),
				'param_name' => 'text3',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 4 (Optional)', 'conceptseven' ),
				'param_name' => 'text4',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Text 5 (Optional)', 'conceptseven' ),
				'param_name' => 'text5',
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Prefix Text (Optional)', 'conceptseven' ),
				'param_name' => 'prefix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'conceptseven' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Suffix Text (Optional)', 'conceptseven' ),
				'param_name' => 'suffix_text',
				'group' => esc_html__( 'Prefix & Suffix', 'conceptseven' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
			),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Text Color', 'conceptseven'),
				'param_name' => 'text_color',
				'value' => '',
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Prefix Text Color', 'conceptseven'),
				'param_name' => 'prefix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'conceptseven' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
            array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Suffix Text Color', 'conceptseven'),
				'param_name' => 'suffix_color',
				'value' => '',
				'group' => esc_html__( 'Prefix & Suffix', 'conceptseven' ),
				'dependency' => array( 'element' => 'animation', 'value' => 'typed' ),
            ),
	        // Typography
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Tag', 'conceptseven' ),
				'param_name' => 'tag',
				'value'      => array(
					'H1' => 'h1',
					'H2' => 'h2',
					'H3' => 'h3',
					'H4' => 'h4',
					'H5' => 'h5',
					'H6' => 'h6',
				),
				'std'		=> 'h2',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Family', 'conceptseven' ),
				'param_name' => 'font_family',
				'value'      =>  conceptseven_plugin_google_font(),
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Font Weight', 'conceptseven' ),
				'param_name' => 'font_weight',
				'value'      => array(
					'Default'		=> 'Default',
					'300' => '300',
					'400' => '400',
					'500' => '500',
					'600' => '600',
					'700' => '700',
					'800' => '800',
					'900' => '900',
				),
				'std'		=> 'Default',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
			),
			array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Max', 'conceptseven' ),
				'param_name' => 'font_max',
				'value' => 70,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
				'description'	=> esc_html__('Important! This size only appear exactly on the full-width grid, 65px max-size on the 1170 grid and 32px max-size on the 570px grid.', 'conceptseven'),
		  	),
		  	array(
				'type' => 'number',
				'heading' => esc_html__( 'Font Size: Min', 'conceptseven' ),
				'param_name' => 'font_min',
				'value' => 22,
				'suffix' => 'px',
				'group' => esc_html__( 'Typography', 'conceptseven' ),
		  	),
        )
    ) );
} );

// Partner Carousel
add_action( 'vc_before_init', function() {
	vc_map( array(
	    'name' => esc_html__('Partner Carousel', 'conceptseven'),
	    'description' => esc_html__('Displaying partner posts in carousel.', 'conceptseven'),
	    'base' => 'partners',
		'weight'	=>	180,
	    'icon' => plugins_url('assets/icon.png', __FILE__),
	    'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
	    'params' => array(
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Border?', 'conceptseven' ),
				'param_name' => 'show_border',
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Spacing between items', 'conceptseven'),
				'param_name' => 'gap',
				'value' => '10',
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'conceptseven' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Infinity Loop?', 'conceptseven' ),
				'param_name' => 'loop',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'description'	=> esc_html__('Duplicate last and first items to get loop illusion.', 'conceptseven'),
			),
			// Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number of items', 'conceptseven'),
				'param_name' => 'items',
				'value' => '5',
				'group' => esc_html__( 'Query', 'conceptseven' ),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Category Slug', 'conceptseven'),
				'param_name' => 'cat_slug',
				'value' => '',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Only show posts from specific category-slug (optional).', 'conceptseven'),
	        ),
	        // Controls
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'conceptseven'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'conceptseven' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'conceptseven' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'conceptseven' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'conceptseven'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'conceptseven' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'conceptseven' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px', 'conceptseven' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px', 'conceptseven' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
	    )
	) );
} );

// Subscribe Form
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Subscribe Form', 'conceptseven'),
        'description' => esc_html__('Displaying mailchimp newsletter form.', 'conceptseven'),
        'base' => 'subscribe',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Style', 'conceptseven' ),
				'param_name' => 'style',
				'value'      => array(
					'Style 1' => 'style-1',
					'Style 2' => 'style-2',
				),
				'std'		=> 'style-1',
			),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Wrap: Padding', 'conceptseven'),
				'param_name' => 'padding',
				'value' => '',
				'description'	=> esc_html__('Top Right Bottom Left. Default: 50px 57px 46px 57px', 'conceptseven'),
	        ),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Wrap: Background', 'conceptseven' ),
				'param_name' => 'background',
				'value'      => array(
					'Accent' => 'accent',
					'Dark' => 'dark',
					'Light' => 'light',
				),
				'std'		=> 'accent',
			),
			array(
				'type' => 'textarea',
				'holder' => 'div',
				'heading' => esc_html__( 'Heading Text', 'conceptseven' ),
				'param_name' => 'heading',
				'value' => 'Newsletter Subscribe'
			),
        )
    ) );
} );

// Google Maps
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Google Maps', 'conceptseven'),
        'description' => esc_html__('Displaying Google Maps.', 'conceptseven'),
        'base' => 'googlemap',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Latitude', 'conceptseven' ),
				'param_name'  => 'lat',
				'description' => '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">'. esc_html__('Here is a tool', 'conceptseven').'</a> '. esc_html__('where you can find Latitude & Longitude of your location', 'conceptseven'),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Longitude', 'conceptseven' ),
				'param_name'  => 'lng',
				'description' => '<a href="http://universimmedia.pagesperso-orange.fr/geo/loc.htm" target="_blank">'. esc_html__('Here is a tool', 'conceptseven').'</a> '. esc_html__('where you can find Latitude & Longitude of your location', 'conceptseven'),
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Map Width', 'conceptseven' ),
				'param_name' => 'width',
				'value'      => ''
			),
			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Map Height', 'conceptseven' ),
				'param_name' => 'height',
				'value'      => 300
			),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Zoom Level', 'conceptseven' ),
				'param_name'  => 'zoom',
				'description' => esc_html__( 'Select the default zoom level for the Maps', 'conceptseven' ),
				'value'       => array_combine( range( 1, 24 ), range( 1, 24 ) ),
				'std'		  => '14'
			),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Dragging on Mobile' ),
                'param_name' => 'drag_mobile',
                'value' => array( esc_html__( 'Enable' ) => 'true', esc_html__( 'Disable' ) => 'false'),
                'std' => 'true'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Dragging on Desktop' ),
                'param_name' => 'drag_desktop',
                'value' => array( esc_html__( 'Enable' ) => 'true', esc_html__( 'Disable' ) => 'false'),
                'std' => 'true'
            ),
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__( 'Show The Marker', 'conceptseven' ),
				'param_name'  => 'marker_type',
				'value'       => array(
					'Simple'          => 'simple',
					'Custom Image' => 'image',
				),
				'std'		=> 'simple',
				'group' => esc_html__( 'Maker', 'conceptseven' ),
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__('Image', 'conceptseven'),
				'param_name' => 'image',
				'value' => '',
				'group' => esc_html__( 'Maker', 'conceptseven' ),
				'dependency' => array( 'element' => 'marker_type', 'value' => 'image' ),
			),
        )
    ) );
} );

// Products Carousel
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('Products Carousel', 'conceptseven'),
        'description' => esc_html__('Displaying products in carousel.', 'conceptseven'),
        'base' => 'dproducts',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
	        // Query
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Number', 'conceptseven'),
				'param_name' => 'number',
				'value' => '4',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('The number of campaigns to show.', 'conceptseven'),
	        ),
	        array(
				'type' => 'textfield',
				'heading' => esc_html__('Item: Space Between', 'conceptseven'),
				'param_name' => 'gap',
				'value' => '30',
				'group' => esc_html__( 'Query', 'conceptseven' ),
				'description'	=> esc_html__('Important! Include the blur distance of the shadow.', 'conceptseven'),
	        ),
	        // Controls
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Item: Auto Scroll?', 'conceptseven' ),
				'param_name' => 'auto_scroll',
				'value'      => array(
					'No' => 'false',
					'Yes' => 'true',
				),
				'std'		=> 'false',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Bullets', 'conceptseven'),
				'param_name' => 'bullets_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Bullets?', 'conceptseven' ),
				'param_name' => 'show_bullets',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Space between Bullets & Images', 'conceptseven' ),
				'param_name' => 'bullet_between',
				'value'      => array(
					'50px' => '50',
					'45px' => '45',
					'40px' => '40',
					'35px' => '35',
					'30px' => '30',
					'25px' => '25',
					'20px' => '20',
					'15px' => '15',
					'10px' => '10',
				),
				'std'		=> '50',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Bullets Show', 'conceptseven' ),
				'param_name' => 'bullet_show',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'Square' => 'bullet-square',
					'Circle' => 'bullet-circle',
				),
				'std'		=> 'bullet-square',
				'dependency' => array( 'element' => 'show_bullets', 'value' => 'yes' ),
			),
			array(
				'type' => 'headings',
				'text' => esc_html__('Arrows', 'conceptseven'),
				'param_name' => 'arrows_heading',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Show Arrows?', 'conceptseven' ),
				'param_name' => 'show_arrows',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array( esc_html__( 'Yes, please.', 'conceptseven' ) => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Horizontal', 'conceptseven' ),
				'param_name' => 'arrow_offset',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-40' => '-40',
					'-35' => '-35',
					'-30' => '-30',
					'-25' => '-25',
					'-20' => '-20',
					'-15' => '-15',
					'-10' => '-10',
					'Center' => 'center',
					'10' => '10',
					'15' => '15',
					'20' => '20',
					'25' => '25',
					'30' => '30',
					'35' => '35',
					'40' => '40',
				),
				'std'		=> 'center',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Arrows Offset: Vertical', 'conceptseven' ),
				'param_name' => 'arrow_offset_v',
				'group' => esc_html__( 'Controls', 'conceptseven' ),
				'value'      => array(
					'-120' => '-120',
					'-110' => '-110',
					'-100' => '-100',
					'-90' => '-90',
					'-80' => '-80',
					'-70' => '-70',
					'-60' => '-60',
					'-50' => '-50',
					'-40' => '-40',
					'-30' => '-30',
					'-20' => '-20',
					'0' => '0',
					'20' => '20',
					'30' => '30',
					'40' => '40',
					'50' => '50',
					'60' => '60',
					'70' => '70',
					'80' => '80',
					'90' => '90',
					'100' => '100',
					'110' => '110',
					'120' => '120',
				),
				'std'		=> '0',
				'dependency' => array( 'element' => 'show_arrows', 'value' => 'yes' ),
			),
			// Columns
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen > 1000px.', 'conceptseven' ),
				'param_name' => 'column',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
					'6 Columns' => '6c',
					'7 Columns' => '7c',
				),
				'std'		=> '3c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen from 600px to 1000px.', 'conceptseven' ),
				'param_name' => 'column2',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
					'5 Columns' => '5c',
				),
				'std'		=> '2c',
			),
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Screen < 600px.', 'conceptseven' ),
				'param_name' => 'column3',
				'group'      => esc_html__( 'Columns', 'conceptseven' ),
				'value'      => array(
					'1 Column' => '1c',
					'2 Columns' => '2c',
					'3 Columns' => '3c',
					'4 Columns' => '4c',
				),
				'std'		=> '1c',
			),
        )
    ) );
} );

// Countdown
add_action( 'vc_before_init', function() {
    vc_map( array(
        'name' => esc_html__('CountDown', 'conceptseven'),
        'description' => esc_html__('Displaying Countdown Timer.', 'conceptseven'),
        'base' => 'countdown',
		'weight'	=>	180,
        'icon' => plugins_url('assets/icon.png', __FILE__),
        'category' => esc_html__('WPRT VC Addons', 'conceptseven'),
        'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => esc_html__( 'Time', 'conceptseven' ),
				'param_name' => 'time',
				'value' => 'December 30, 2020 8:30:00'
			),
        )
    ) );
} );