<?php
/**
 * Header setting for Customizer
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Header General
$this->sections['conceptseven_header_general'] = array(
	'title' => esc_html__( 'General', 'conceptseven' ),
	'panel' => 'conceptseven_header',
	'settings' => array(
		// Header 1
		array(
			'id' => 'header_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_one',
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #site-header:after'
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'header_background_opacity',
			'transport' => 'postMessage',
			'default' => '1',
			'control' => array(
				'label'  => esc_html__( 'Background Opacity', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_one',
				'type' => 'select',
				'choices' => array(
					'1' => esc_html__( '1', 'conceptseven' ),
					'0.9' => esc_html__( '0.9', 'conceptseven' ),
					'0.8' => esc_html__( '0.8', 'conceptseven' ),
					'0.7' => esc_html__( '0.7', 'conceptseven' ),
					'0.6' => esc_html__( '0.6', 'conceptseven' ),
					'0.5' => esc_html__( '0.5', 'conceptseven' ),
					'0.4' => esc_html__( '0.4', 'conceptseven' ),
					'0.3' => esc_html__( '0.3', 'conceptseven' ),
					'0.2' => esc_html__( '0.2', 'conceptseven' ),
					'0.1' => esc_html__( '0.1', 'conceptseven' ),
					'0.0001' => esc_html__( '0', 'conceptseven' ),
				),
			),
			'inline_css' => array(
				'target' => '.header-style-1 #site-header:after',
				'alter' => 'opacity',
			),
		),
		array(
			'id' => 'header_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_one',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 1199px)',
				'target' => '.header-style-1 #site-header-inner',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'header_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Width', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_one',
			),
			'inline_css' => array(
				'target' => '.header-style-1 #site-header',
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'header_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Border Color', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_one',
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '.header-style-1 #site-header',
				'alter' => 'border-color',
			),
		),
		// Header 2 - Dark
		array(
			'id' => 'header_two_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_two',
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-2 #site-header'
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'header_two_background_opacity',
			'transport' => 'postMessage',
			'default' => '1',
			'control' => array(
				'label'  => esc_html__( 'Background Opacity', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_two',
				'type' => 'select',
				'choices' => array(
					'1' => esc_html__( '1', 'conceptseven' ),
					'0.9' => esc_html__( '0.9', 'conceptseven' ),
					'0.8' => esc_html__( '0.8', 'conceptseven' ),
					'0.7' => esc_html__( '0.7', 'conceptseven' ),
					'0.6' => esc_html__( '0.6', 'conceptseven' ),
					'0.5' => esc_html__( '0.5', 'conceptseven' ),
					'0.4' => esc_html__( '0.4', 'conceptseven' ),
					'0.3' => esc_html__( '0.3', 'conceptseven' ),
					'0.2' => esc_html__( '0.2', 'conceptseven' ),
					'0.1' => esc_html__( '0.1', 'conceptseven' ),
					'0.0001' => esc_html__( '0', 'conceptseven' ),
				),
			),
			'inline_css' => array(
				'target' => '.header-style-2 #site-header:after',
				'alter' => 'opacity',
			),
		),
		array(
			'id' => 'header_two_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_two',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 1199px)',
				'target' => '.header-style-2 #site-header .conceptseven-container',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'header_two_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Width', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_two',
			),
			'inline_css' => array(
				'target' => '.header-style-2 #site-header',
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'header_two_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Border Color', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_two',
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '.header-style-2 #site-header',
				'alter' => 'border-color',
			),
		),
		// Header 3 - Transparent (Dark-Text)

		// Header 4 - Transparent (Light-Text)
		array(
			'id' => 'header_four_background',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_four',
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-4 #site-header:after'
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'header_four_background_opacity',
			'transport' => 'postMessage',
			'default' => '0.0001',
			'control' => array(
				'label'  => esc_html__( 'Background Opacity', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_four',
				'type' => 'select',
				'choices' => array(
					'1' => esc_html__( '1', 'conceptseven' ),
					'0.9' => esc_html__( '0.9', 'conceptseven' ),
					'0.8' => esc_html__( '0.8', 'conceptseven' ),
					'0.7' => esc_html__( '0.7', 'conceptseven' ),
					'0.6' => esc_html__( '0.6', 'conceptseven' ),
					'0.5' => esc_html__( '0.5', 'conceptseven' ),
					'0.4' => esc_html__( '0.4', 'conceptseven' ),
					'0.3' => esc_html__( '0.3', 'conceptseven' ),
					'0.2' => esc_html__( '0.2', 'conceptseven' ),
					'0.1' => esc_html__( '0.1', 'conceptseven' ),
					'0.0001' => esc_html__( '0', 'conceptseven' ),
				),
			),
			'inline_css' => array(
				'target' => '.header-style-4 #site-header:after',
				'alter' => 'opacity',
			),
		),
		array(
			'id' => 'header_four_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_four',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 1199px)',
				'target' => '.header-style-4 #site-header-inner',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'header_four_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Width', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_four',
			),
			'inline_css' => array(
				'target' => '.header-style-4 #site-header',
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'header_four_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Border Color', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_four',
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => '.header-style-4 #site-header',
				'alter' => 'border-color',
			),
		),
	)
);

// Header Logo
$this->sections['conceptseven_header_logo'] = array(
	'title' => esc_html__( 'Logo', 'conceptseven' ),
	'panel' => 'conceptseven_header',
	'settings' => array(
		// Logo 1
		array(
			'id' => 'logo_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Logo Margin', 'conceptseven' ),
		 		'description' => esc_html__( 'Top Right Bottom Left. Example: 30px 0px 0px 0px.', 'conceptseven' ),
		 		'active_callback' => 'conceptseven_cac_has_header_one',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 992px)',
				'target' => '.header-style-1 #site-logo-inner',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'custom_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Logo Image', 'conceptseven' ),
				'type' => 'image',
				'active_callback' => 'conceptseven_cac_has_header_one',
			),
		),
		array(
			'id' => 'logo_width',
			'control' => array(
				'label' => esc_html__( 'Logo Width', 'conceptseven' ),
				'type' => 'text',
				'active_callback' => 'conceptseven_cac_has_header_one',
			),
		),
		// Logo 2
		array(
			'id' => 'logotwo_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Logo Margin', 'conceptseven' ),
		 		'description' => esc_html__( 'Top Right Bottom Left. Example: 30px 0px 0px 0px.', 'conceptseven' ),
		 		'active_callback' => 'conceptseven_cac_has_header_two',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 992px)',
				'target' => '.header-style-2 #site-logo-inner',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'custom_logotwo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Logo Image', 'conceptseven' ),
				'type' => 'image',
				'active_callback' => 'conceptseven_cac_has_header_two',
			),
		),
		array(
			'id' => 'logotwo_width',
			'control' => array(
				'label' => esc_html__( 'Logo Width', 'conceptseven' ),
				'type' => 'text',
				'active_callback' => 'conceptseven_cac_has_header_two',
			),
		),
		// Logo 3
		array(
			'id' => 'logothree_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Logo Margin', 'conceptseven' ),
		 		'description' => esc_html__( 'Top Right Bottom Left. Example: 30px 0px 0px 0px.', 'conceptseven' ),
		 		'active_callback' => 'conceptseven_cac_has_header_three',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 992px)',
				'target' => '.header-style-3 #site-logo-inner',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'custom_logothree',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Logo Image', 'conceptseven' ),
				'type' => 'image',
				'active_callback' => 'conceptseven_cac_has_header_three',
			),
		),
		array(
			'id' => 'logothree_width',
			'control' => array(
				'label' => esc_html__( 'Logo Width', 'conceptseven' ),
				'type' => 'text',
				'active_callback' => 'conceptseven_cac_has_header_three',
			),
		),
		// Logo 4
		array(
			'id' => 'logofour_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Logo Margin', 'conceptseven' ),
		 		'description' => esc_html__( 'Top Right Bottom Left. Example: 30px 0px 0px 0px.', 'conceptseven' ),
		 		'active_callback' => 'conceptseven_cac_has_header_four',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 992px)',
				'target' => '.header-style-4 #site-logo-inner',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'custom_logofour',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Logo Image', 'conceptseven' ),
				'type' => 'image',
				'active_callback' => 'conceptseven_cac_has_header_four',
			),
		),
		array(
			'id' => 'logofour_width',
			'control' => array(
				'label' => esc_html__( 'Logo Width', 'conceptseven' ),
				'type' => 'text',
				'active_callback' => 'conceptseven_cac_has_header_four',
			),
		),
	)
);

// Header Menu
$this->sections['conceptseven_header_menu'] = array(
	'title' => esc_html__( 'Menu', 'conceptseven' ),
	'panel' => 'conceptseven_header',
	'settings' => array(
		// General
		array(
			'id' => 'menu_link_spacing',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Link Spacing', 'conceptseven' ),
				'description' => esc_html__( 'Example: 20px', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'#main-nav > ul > li',
				),
				'alter' => array(
					'padding-left',
					'padding-right',
				),
			),
		),
		array(
			'id' => 'menu_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Menu Height', 'conceptseven' ),
				'description' => esc_html__( 'Example: 100px', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'#site-header #main-nav > ul > li > a',
				),
				'alter' => array(
					'height',
					'line-height',
				),
			),
		),
		// Header 1
		array(
			'id' => 'menu_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_one',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #main-nav > ul > li > a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_one',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-1 #main-nav > ul > li > a:hover',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_link_current',
			'default' => 'cur-menu-1',
			'control' => array(
				'label' => esc_html__( 'Current Link Style', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'cur-menu-1' => esc_html__( 'Style 1', 'conceptseven' ),
					'cur-menu-2'  => esc_html__( 'Style 2', 'conceptseven' ),
				),
			),
		),
		// Header 2
		array(
			'id' => 'menu_two_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_two',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-2 #main-nav > ul > li > a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_two_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_two',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-2 #main-nav > ul > li > a:hover',
				),
				'alter' => 'color',
			),
		),
		// Header 3
		array(
			'id' => 'menu_three_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_three',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-3 #main-nav > ul > li > a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_three_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_three',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-3 #main-nav > ul > li > a:hover',
				),
				'alter' => 'color',
			),
		),
		// Header 4
		array(
			'id' => 'menu_four_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_four',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-4 #main-nav > ul > li > a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'menu_four_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_header_four',
			),
			'inline_css' => array(
				'target' => array(
					'.header-style-4 #main-nav > ul > li > a:hover',
				),
				'alter' => 'color',
			),
		),
	)
);

// Search & Cart
$this->sections['conceptseven_header_search_cart'] = array(
	'title' => esc_html__( 'Search & Cart Icon', 'conceptseven' ),
	'panel' => 'conceptseven_header',
	'settings' => array(
		// Search Icon
		array(
			'id' => 'header_search_icon',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Search Icon', 'conceptseven' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'header_search_icon_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Search Icon: Margin', 'conceptseven' ),
				'description' => esc_html__( 'Example: 30px 0px 30px 10px', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.search-style-fullscreen',
				'alter' => 'margin',
			),
		),
		// Cart Icon
		array(
			'id' => 'header_cart_icon',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Cart Icon', 'conceptseven' ),
				'type' => 'checkbox',
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'header_cart_icon_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Cart Icon: Margin', 'conceptseven' ),
				'description' => esc_html__( 'Example: 30px 0px 30px 10px', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.nav-top-cart-wrapper',
				'alter' => 'padding',
			),
		),
	)
);