<?php
/**
 * Projects setting for Customizer
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Project Related General
$this->sections['conceptseven_projects_general'] = array(
	'title' => esc_html__( 'General', 'conceptseven' ),
	'panel' => 'conceptseven_projects',
	'settings' => array(
		array(
			'id' => 'project_related',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'conceptseven' ),
				'type' => 'checkbox',
				'active_callback' => 'conceptseven_cac_has_single_project',
			),
		),
		array(
			'id' => 'project_related_title',
			'default' => esc_html__( 'Related Projects', 'conceptseven' ),
			'control' => array(
				'label' => esc_html__( 'Project Related Title', 'conceptseven' ),
				'type' => 'text',
				'active_callback' => 'conceptseven_cac_has_related_project',
			),
		),
		array(
			'id' => 'project_related_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 100px 0px 100px 0px', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_related_project',
			),
			'inline_css' => array(
				'target' => '.project-related-wrap',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'project_related_query',
			'default' => 7,
			'control' => array(
				'label' => esc_html__( 'Number of items', 'conceptseven' ),
				'type' => 'number',
				'active_callback' => 'conceptseven_cac_has_related_project',
			),
		),
		array(
			'id' => 'project_related_column',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Columns', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'4' => '4',
					'3' => '3',
					'2' => '2',
				),
				'active_callback' => 'conceptseven_cac_has_related_project',
			),
		),
		array(
			'id' => 'project_related_item_spacing',
			'default' => 30,
			'control' => array(
				'label' => esc_html__( 'Spacing between items', 'conceptseven' ),
				'type' => 'number',
				'active_callback' => 'conceptseven_cac_has_related_project',
			),
		),
		array(
			'id' => 'project_related_img_crop',
			'default' => 'post-related',
			'control' => array(
				'label' => esc_html__( 'Image Size', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'rectangle1' => '640 x 440',
					'post-related' => '570 x 277',
				),
				'active_callback' => 'conceptseven_cac_has_related_project',
			),
		),

	),
);