<?php
/**
 * Shop setting for Customizer
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Main Shop
$this->sections['conceptseven_shop_general'] = array(
	'title' => esc_html__( 'Main Shop', 'conceptseven' ),
	'panel' => 'conceptseven_shop',
	'settings' => array(
		array(
			'id' => 'shop_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Shop Layout Position', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'conceptseven' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'conceptseven' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'conceptseven' ),
				),
				'desc' => esc_html__( 'Specify layout for main shop page.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_title',
			'default' => esc_html__( 'Our Shop', 'conceptseven' ),
			'control' => array(
				'label' => esc_html__( 'Shop: Featured Title', 'conceptseven' ),
				'type' => 'text',
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_subtitle',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Shop: Featured Sub-Title', 'conceptseven' ),
				'type' => 'conceptseven_textarea',
				'rows' => 5,
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Shop: Featured Title Background', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_products_per_page',
			'default' => 6,
			'control' => array(
				'label' => esc_html__( 'Products Per Page', 'conceptseven' ),
				'type' => 'number',
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Shop Columns', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_item_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Item Bottom Margin', 'conceptseven' ),
				'description' => esc_html__( 'Example: 30px.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_woo',
			),
			'inline_css' => array(
				'target' => '.products li',
				'alter' => 'margin-top',
			),
		),
	),
);

// Single Shop
$this->sections['conceptseven_single_shop_general'] = array(
	'title' => esc_html__( 'Single Shop', 'conceptseven' ),
	'panel' => 'conceptseven_shop',
	'settings' => array(
		array(
			'id' => 'shop_single_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Shop Single Layout Position', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'conceptseven' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'conceptseven' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'conceptseven' ),
				),
				'desc' => esc_html__( 'Specify layout on the shop single page.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_title',
			'default' => esc_html__( 'Our Shop', 'conceptseven' ),
			'control' => array(
				'label' => esc_html__( 'Shop Single: Featured Title', 'conceptseven' ),
				'type' => 'text',
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_subtitle',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Shop Single: Featured Sub-Title', 'conceptseven' ),
				'type' => 'conceptseven_textarea',
				'rows' => 5,
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Shop Single: Featured Title Background', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_woo',
			),
		),
	),
);