<?php
/**
 * Top Bar / Content
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get top content
$custom = conceptseven_get_mod( 'top_bar_content_custom', '' );
$phone = conceptseven_get_mod( 'top_bar_content_phone', 'Call: (+1) 212-946-2707' );
$email = conceptseven_get_mod( 'top_bar_content_email', '' );
$address = conceptseven_get_mod( 'top_bar_content_address', '' );
?>

<div class="top-bar-content">
    <?php
    // Top content
    if ( $custom ) : ?>
        <span class="custom content">
            <?php echo do_shortcode( $custom ); ?>
        </span>
    <?php endif;

    if ( $phone ) : ?>
        <span class="phone content">
            <?php echo do_shortcode( $phone ); ?>
        </span>
    <?php endif;

    if ( $email ) : ?>
        <span class="email content">
            <?php echo do_shortcode( $email ); ?>
        </span>
    <?php endif;

    if ( $address ) : ?>
        <span class="address content">
            <?php echo do_shortcode( $address ); ?>
        </span>
    <?php endif; ?>
</div><!-- /.top-bar-content -->

