<?php
/**
 * Blog setting for Customizer
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Blog Posts General
$this->sections['conceptseven_blog_post'] = array(
	'title' => esc_html__( 'General', 'conceptseven' ),
	'panel' => 'conceptseven_blog',
	'settings' => array(
		array(
			'id' => 'blog_featured_title',
			'default' => esc_html__( 'Latest News', 'conceptseven' ),
			'control' => array(
				'label' => esc_html__( 'Blog Featured Title', 'conceptseven' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'blog_featured_subtitle',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Blog Featured Sub-Title', 'conceptseven' ),
				'type' => 'conceptseven_textarea',
				'rows' => 5,
			),
		),
		array(
			'id' => 'blog_entry_content_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Entry Content Background Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.post-content-wrap',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'blog_entry_content_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Content Padding', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-content-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'blog_entry_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Bottom Margin', 'conceptseven' ),
				'description' => esc_html__( 'Example: 30px.', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry',
				'alter' => 'margin-top',
			),
		),
		array(
			'id' => 'blog_entry_bottom_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Entry Bottom Padding', 'conceptseven' ),
				'description' => esc_html__( 'Example: 30px.', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry',
				'alter' => 'padding-top',
			),
		),
		array(
			'id' => 'blog_entry_border_width',
			'transport' => 'postMessage',
			'control' => array (
				'type' => 'text',
				'label' => esc_html__( 'Entry Border Width', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0px 2px 0px 0px', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry',
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'blog_entry_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Entry Border Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry',
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'blog_entry_composer',
			'default' => 'meta,title,excerpt_content,readmore',
			'control' => array(
				'label' => esc_html__( 'Entry Content Elements', 'conceptseven' ),
				'type' => 'conceptseven-sortable',
				'object' => 'Conceptseven_Customize_Control_Sorter',
				'choices' => array(
					'title'           => esc_html__( 'Title', 'conceptseven' ),
					'meta'            => esc_html__( 'Meta', 'conceptseven' ),
					'excerpt_content' => esc_html__( 'Excerpt', 'conceptseven' ),
					'readmore'        => esc_html__( 'Read More', 'conceptseven' ),
				),
				'desc' => esc_html__( 'Drag and drop elements to re-order.', 'conceptseven' ),
			),
		),
	),
);

// Blog Posts Title
$this->sections['conceptseven_blog_post_title'] = array(
	'title' => esc_html__( 'Blog Post - Title', 'conceptseven' ),
	'panel' => 'conceptseven_blog',
	'settings' => array(
		array(
			'id' => 'blog_title_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-title',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'blog_title_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'.hentry .post-title a',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_title_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color Hover', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-title a:hover',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Meta
$this->sections['conceptseven_blog_post_meta'] = array(
	'title' => esc_html__( 'Blog Post - Meta', 'conceptseven' ),
	'panel' => 'conceptseven_blog',
	'settings' => array(
		array(
			'id' => 'blog_entry_meta_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Meta Margin', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0 0 20px 0.', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta',
				'alter' => 'margin',
			),
		),
		array(
			'id'  => 'blog_entry_meta_items',
			'default' => array( 'categories', 'date' ),
			'control' => array(
				'label' => esc_html__( 'Meta Items', 'conceptseven' ),
				'desc' => esc_html__( 'Click and drag and drop elements to re-order them.', 'conceptseven' ),
				'type' => 'conceptseven-sortable',
				'object' => 'Conceptseven_Customize_Control_Sorter',
				'choices' => array(
					'date'       => esc_html__( 'Date', 'conceptseven' ),
					'categories' => esc_html__( 'Categories', 'conceptseven' ),
					'author'     => esc_html__( 'Author', 'conceptseven' ),
					'comments' => esc_html__( 'Comments', 'conceptseven' ),
				),
			),
		),
		array(
			'id' => 'heading_blog_entry_meta_item',
			'control' => array(
				'type' => 'conceptseven-heading',
				'label' => esc_html__( 'Item Meta', 'conceptseven' ),
			),
		),
		array(
			'id' => 'blog_entry_meta_item_sep_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Separate Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array(
					'.hentry .post-meta .item .inner:before',
				),
				'alter' => array(
					'background-color',
				),
			),
		),
		array(
			'id' => 'blog_entry_meta_item_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_entry_meta_item_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'blog_entry_meta_item_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color Hover', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-meta .item a:hover',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Excerpt
$this->sections['conceptseven_blog_post_excerpt'] = array(
	'title' => esc_html__( 'Blog Post - Excerpt', 'conceptseven' ),
	'panel' => 'conceptseven_blog',
	'settings' => array(
		array(
			'id' => 'blog_content_style',
			'default' => 'style-1',
			'control' => array(
				'label' => esc_html__( 'Content Style', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'style-1' => esc_html__( 'Normal', 'conceptseven' ),
					'style-2' => esc_html__( 'Excerpt', 'conceptseven' ),
				),
			),
		),
		array(
			'id' => 'blog_excerpt_length',
			'default' => '50',
			'control' => array(
				'label' => esc_html__( 'Excerpt length', 'conceptseven' ),
				'type' => 'text',
				'desc' => esc_html__( 'This option only apply for Content Style: Excerpt.', 'conceptseven' )
			),
		),
		array(
			'id' => 'blog_excerpt_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Margin', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left. Example: 0 0 30px 0.', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-excerpt',
				'alter' => 'margin',
			),
		),
		array(
			'id' => 'blog_excerpt_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '.hentry .post-excerpt',
				'alter' => 'color',
			),
		),
	),
);

// Blog Posts Read More
$this->sections['conceptseven_blog_post_read_more'] = array(
	'title' => esc_html__( 'Blog Post - Read More', 'conceptseven' ),
	'panel' => 'conceptseven_blog',
	'settings' => array(
		array(
			'id' => 'blog_entry_button_read_more_text',
			'default' => esc_html__( 'Read more', 'conceptseven' ),
			'control' => array(
				'label' => esc_html__( 'Button Text', 'conceptseven' ),
				'type' => 'text',
			),
		),
	),
);

