<?php
/**
 * Bottom Bar setting for Customizer
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Bottom Bar General
$this->sections['conceptseven_bottombar_general'] = array(
	'title' => esc_html__( 'General', 'conceptseven' ),
	'panel' => 'conceptseven_bottombar',
	'settings' => array(
		array(
			'id' => 'bottom_bar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'conceptseven' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'bottom_copyright',
			'transport' => 'postMessage',
			'default' => '&copy; Concept Seven. All rights reserved.',
			'control' => array(
				'label' => esc_html__( 'Copyright', 'conceptseven' ),
				'type' => 'conceptseven_textarea',
				'active_callback' => 'conceptseven_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_padding',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'conceptseven' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'conceptseven' ),
				'active_callback'=> 'conceptseven_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom .bottom-bar-inner-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'bottom_background',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'conceptseven' ),
				'active_callback'=> 'conceptseven_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'background',
			),
		),
		array(
			'id' => 'bottom_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Background Image', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_background_img_style',
			'default' => 'repeat',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'conceptseven' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'conceptseven' ),
					'cover'        => esc_html__( 'Cover', 'conceptseven' ),
					'center-top'        => esc_html__( 'Center Top', 'conceptseven' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'conceptseven' ),
					'fixed'        => esc_html__( 'Fixed Center', 'conceptseven' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'conceptseven' ),
					'repeat'       => esc_html__( 'Repeat', 'conceptseven' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'conceptseven' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'conceptseven' ),
				),
				'active_callback' => 'conceptseven_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'conceptseven' ),
				'active_callback'=> 'conceptseven_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'bottom_link_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Links', 'conceptseven' ),
				'active_callback'=> 'conceptseven_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => array(
					'#bottom a',
					'#bottom ul.bottom-nav > li > a'
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'bottom_link_color_hover',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Links: Hover', 'conceptseven' ),
				'active_callback'=> 'conceptseven_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => array(
					'#bottom a:hover',
					'#bottom ul.bottom-nav > li > a:hover'
				),
				'alter' => 'color',
			),
		),
	),
);