<?php
/**
 * Layout setting for Customizer
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Layout Style
$this->sections['conceptseven_layout_style'] = array(
	'title' => esc_html__( 'Layout Site', 'conceptseven' ),
	'panel' => 'conceptseven_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_style',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Layout Style', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'full-width' => esc_html__( 'Full Width','conceptseven' ),
					'boxed' => esc_html__( 'Boxed','conceptseven' )
				),
			),
		),
		array(
			'id' => 'site_layout_boxed_shadow',
			'control' => array(
				'label' => esc_html__( 'Box Shadow', 'conceptseven' ),
				'type' => 'checkbox',
				'active_callback' => 'conceptseven_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'site_layout_wrapper_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Wrapper Margin', 'conceptseven' ),
				'desc' => esc_html__( 'Top Right Bottom Left. Default: 30px 0px 30px 0px.', 'conceptseven' ),
				'active_callback' => 'conceptseven_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'wrapper_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Outer Background Color', 'conceptseven' ),
				'type' => 'color',
				'active_callback' => 'conceptseven_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'wrapper_background_img',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image', 'conceptseven' ),
				'type' => 'image',
				'active_callback' => 'conceptseven_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'wrapper_background_img_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image Style', 'conceptseven' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'conceptseven' ),
					'cover'        => esc_html__( 'Cover', 'conceptseven' ),
					'center-top'        => esc_html__( 'Center Top', 'conceptseven' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'conceptseven' ),
					'fixed'        => esc_html__( 'Fixed Center', 'conceptseven' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'conceptseven' ),
					'repeat'       => esc_html__( 'Repeat', 'conceptseven' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'conceptseven' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'conceptseven' ),
				),
				'active_callback' => 'conceptseven_cac_has_boxed_layout',
			),
		),
	),
);

// Layout Position
$this->sections['conceptseven_layout_position'] = array(
	'title' => esc_html__( 'Layout Position', 'conceptseven' ),
	'panel' => 'conceptseven_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Site Layout Position', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'conceptseven' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'conceptseven' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'conceptseven' ),
				),
				'desc' => esc_html__( 'Specify layout for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings metabox when edit.', 'conceptseven' )
			),
		),
		array(
			'id' => 'single_post_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Single Post Layout Position', 'conceptseven' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'conceptseven' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'conceptseven' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'conceptseven' ),
				),
				'desc' => esc_html__( 'Specify layout for all single post pages.', 'conceptseven' )
			),
		),
	),
);

// Layout Widths
$this->sections['conceptseven_layout_widths'] = array(
	'title' => esc_html__( 'Layout Widths', 'conceptseven' ),
	'panel' => 'conceptseven_layout',
	'settings' => array(
		array(
			'id' => 'site_desktop_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Container', 'conceptseven' ),
				'type' => 'text',
				'desc' => esc_html__( 'Default: 1170px', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => array( 
					'.site-layout-full-width .conceptseven-container',
					'.site-layout-boxed #page'
				),
				'alter' => 'width',
			),
		),
		array(
			'id' => 'left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content', 'conceptseven' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 66%', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '#site-content',
				'alter' => 'width',
			),
		),
		array(
			'id' => 'sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar', 'conceptseven' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 28%', 'conceptseven' ),
			),
			'inline_css' => array(
				'target' => '#sidebar',
				'alter' => 'width',
			),
		),
	),
);