<?php
/**
 * Footer Promotion
 *
 * @package conceptseven
 * @version 3.6.8
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Exit if disabled via Customizer or Metabox
if ( ! conceptseven_get_mod( 'promotion_box', false ) || ( is_page() && conceptseven_metabox('hide_footer_promo') ) )
	return false;

$html = $icon = '';
$title = conceptseven_get_mod( 'promo_title', 'Get an estimate of your project’s time and costs.' );
$button = conceptseven_get_mod( 'promo_button', 'Get in Touch' );
$text = conceptseven_get_mod( 'promo_extra_text', '' );
$button_url = conceptseven_get_mod( 'promo_button_url', '#' );

if ( $title )
	$html .= sprintf(
	'<div class="title-wrap">
		<div class="text-wrap">
			<div class="promo-icon">%1$s</div>
			<h5 class="promo-title">%2$s</h5>
		</div>
	</div>', $icon, $title );

if ( $button)
	$html .= sprintf(
	'<div class="button-wrap">
		<div class="btn">
			<a href="%1$s" class="promo-btn">
				<span>%2$s</span>
			</a>
		</div>
		<div class="btn-ex">
			%3$s
		</div>
	</div>', $button_url, $button, do_shortcode( $text ) );

if ( $html )
	printf(
		'<div class="footer-promotion" style="%2$s">
			<div class="conceptseven-container">
				<div class="inner">%s</div>
			</div>
		</div>',
		$html,
		conceptseven_element_bg_css('promo_background_img')
	);

