<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$css = $data = $image_css = $heading_css = $sep_css = $desc_css = $button_cls = $button_css = $inner_css = $thumb_css = $content_css = $content_cls = $image_html = $heading_html = $sep_html = $desc_html = $url_html = $url_wrap_css = $button_data = '';

extract( shortcode_atts( array(
    'style' => 'style-1',
    'animation' => '',
    'animation_effect' => 'fadeInUp',
    'animation_duration' => '0.75s',
    'animation_delay' => '0.3s',
    'alignment' => '',
    'image'    => '',
    'content_padding' => '',
    'box_shadow' => '',
    'tag' => 'h3',
    'heading' => 'Heading Text',
    'separator' => '',
    'line_full' => 'no',
    'line_width' => '50',
    'line_height' => '2',
    'line_color' => '#eee',
    'description' => '',
    'show_url' => '',
    'url_style' => 'link',
    'link_text' => 'READ MORE',
    'link_url' => '',
    'new_tab' => 'yes',
    'button_style' => 'background',
    'button_size' => 'medium',
    'button_rounded' => '',
    'button_text_color' => '',
    'button_background' => '',
    'button_border' => '',
    'button_text_hover' => '',
    'button_background_hover' => '',
    'button_border_hover' => '',
    'heading_font_family' => 'Default',
    'heading_font_weight' => 'Default',
    'heading_font_size' => '',
    'heading_line_height' => '',
    'desc_font_family' => 'Default',
    'desc_font_weight' => 'Default',
    'desc_font_size' => '',
    'desc_line_height' => '',
    'button_font_family' => 'Default',
    'button_font_weight' => 'Default',
    'button_font_size' => '',
    'heading_top_margin' => '',
    'heading_bottom_margin' => '',
    'desc_top_margin' => '',
    'desc_bottom_margin' => '',
    'sep_top_margin' => '',
    'sep_bottom_margin' => ''
), $atts ) );

$line_height = intval( $line_height );
$heading_line_height = intval( $heading_line_height );
$desc_line_height = intval( $desc_line_height );
$heading_font_size = intval( $heading_font_size );
$desc_font_size = intval( $desc_font_size );
$button_font_size = intval( $button_font_size );
$button_rounded = intval( $button_rounded );
$heading_top_margin = intval( $heading_top_margin );
$heading_bottom_margin = intval( $heading_bottom_margin );
$sep_top_margin = intval( $sep_top_margin );
$sep_bottom_margin = intval( $sep_bottom_margin );
$desc_top_margin = intval( $desc_top_margin );
$desc_bottom_margin = intval( $desc_bottom_margin );

$cls = $style .' '. $alignment;
if ( $box_shadow ) $cls .= ' has-shadow'; 
$new_tab = $new_tab == 'yes' ? '_blank' : '_self'; 

if ( $heading_font_weight != 'Default' ) $heading_css .= 'font-weight:'. $heading_font_weight .';';
if ( $heading_font_size ) $heading_css .= 'font-size:'. $heading_font_size .'px;';
if ( $heading_line_height ) $heading_css .= 'line-height:'. $heading_line_height .'px;';
if ( $heading_top_margin ) $heading_css .= 'margin-top:'. $heading_top_margin .'px;';
if ( $heading_bottom_margin ) $heading_css .= 'margin-bottom:'. $heading_bottom_margin .'px;';
if ( $heading_font_family != 'Default' ) {
    conceptseven_enqueue_google_font( $heading_font_family );
    $heading_css .= 'font-family:'. $heading_font_family .';';
}

if ( $desc_font_weight != 'Default' ) $desc_css .= 'font-weight:'. $desc_font_weight .';';
if ( $desc_font_size ) $desc_css .= 'font-size:'. $desc_font_size .'px;';
if ( $desc_line_height ) $desc_css .= 'line-height:'. $desc_line_height .'px;';
if ( $desc_top_margin ) $desc_css .= 'margin-top:'. $desc_top_margin .'px;';
if ( $desc_bottom_margin ) $desc_css .= 'margin-bottom:'. $desc_bottom_margin .'px;';
if ( $desc_font_family != 'Default' ) {
    conceptseven_enqueue_google_font( $desc_font_family );
    $desc_css .= 'font-family:'. $desc_font_family .';';
}

if ( $button_font_weight != 'Default' ) $button_css .= 'font-weight:'. $button_font_weight .';';
if ( $button_font_size ) $button_css .= 'font-size:'. $button_font_size .'px;';
if ( $button_font_family != 'Default' ) {
    conceptseven_enqueue_google_font( $button_font_family );
    $button_css .= 'font-family:'. $button_font_family .';';
}

if ( $image ) {
    $image_html .= sprintf(
        '<div class="thumb" style="%2$s">%1$s</div>',
        wp_get_attachment_image( $image, 'full' ),
        $thumb_css
    );
}

if ( $heading )
    $heading_html .= sprintf(
    '<%3$s class="title" style="%2$s">
        %1$s
    </%3$s>',
    esc_html( $heading ),
    $heading_css,
    $tag
);

if ($separator == 'line' ) {
    if ( $line_full == 'yes' ) {
        $sep_css = 'width:100%;';
    } else {
        $line_width = intval( $line_width );
        if ( $line_width ) $sep_css = 'width:'. $line_width .'px;';
    }

    if ( $alignment == 'text-center' ) $sep_css .= 'margin: 0 auto;';

    if ( $line_height ) $sep_css .= 'height:'. $line_height .'px;';
    if ( $line_color ) $sep_css .= 'background-color:'. $line_color .';';
    if ( $sep_top_margin ) $sep_css .= 'margin-top:'. $sep_top_margin .'px;';
    if ( $sep_bottom_margin ) $sep_css .= 'margin-bottom:'. $sep_bottom_margin .'px;';
    
    $sep_html .= sprintf( '<div class="clearfix"></div><div class="sep" style="%1$s"></div>', $sep_css );
}

if ( $description )
    $desc_html .= sprintf(
    '<div class="desc" style="%2$s">%1$s</div>',
    $description, $desc_css
);

if ( $url_style == 'link' && $link_url ) {
    $url_html .= sprintf(
        '<div class="url-wrap" style="%5$s">
            <a target="%3$s" class="conceptseven-links style-2 %3$s" href="%2$s" style="%4$s">
                <span class="text">%1$s</span>
                <span class="line " style=""></span>
            </a>
        </div>',
        esc_html( $link_text ),
        esc_attr( $link_url ),
        $new_tab,
        $button_css,
        $url_wrap_css
    );
}

if ( $url_style == 'button' && $link_url ) {
    $rand = rand();
    $button_cls = $button_size;
    $button_cls = 'big btn-'. $rand;

    if ( $button_rounded ) $button_css .= 'border-radius:'. $button_rounded .'px;';

    if ( $button_text_color ) $button_data .= ' data-text="'. $button_text_color .'"';

    if ( $button_style == 'background' ) {
        if ( $button_background == '#265cdc' ) {
            $button_cls .= ' accent';
        } else {
            $button_cls .= ' custom';
            $button_data .= ' data-background="'. $button_background .'"';
        }
    }

    if ( $button_style == 'outline' ) {
        $button_cls .= ' outline solid';
        if ( $button_border == '#265cdc' ) {
            $button_cls .= ' outline-accent';
        } else {
            $button_cls .= ' custom';
            $button_data .= ' data-border="'. $button_border .'"';
        }
    }       

    if ( $button_text_hover ) $button_data .= ' data-text-hover="'. $button_text_hover .'"';
    if ( $button_background_hover ) $button_data .= ' data-background-hover="'. $button_background_hover .'"';
    if ( $button_border_hover ) $button_data .= ' data-border-hover="'. $button_border_hover .'"';

    $url_html .= sprintf(
        '<div class="url-wrap" style="%6$s">
            <a target="%5$s" class="conceptseven-button %3$s" href="%2$s" style="%4$s" %7$s>%1$s</a>
        </div>',
        esc_html( $link_text ),
        esc_attr( $link_url ),
        $button_cls,
        $button_css,
        $new_tab,
        $url_wrap_css,
        $button_data
    );
}

if ( $animation ) {
    $cls .= ' wow '. $animation_effect;
    $data .= ' data-wow-duration="'. $animation_duration .'" data-wow-delay="'. $animation_delay .'"';
}

if ( $content_padding ) {
    $content_css .= ' padding:'. $content_padding .';';
}

printf(
    '<div class="conceptseven-image-box clearfix %6$s" style="%7$s" %9$s>
        <div class="item">
            <div class="inner">
                %1$s
                <div class="text-wrap %10$s" style="%5$s">
                    %2$s %8$s %3$s %4$s
                </div>
            </div>
        </div>
    </div>', 
    $image_html,
    $heading_html,
    $desc_html,
    $url_html,
    $content_css,
    $cls,
    $css,
    $sep_html,
    $data,
    $content_cls
);